// Generate the surface figure "windrose" that consists of cones
#include <CoreAPI.h>
//@config: Debug
EXPORT
int main() {
	// get to sculpt room
	coat::ui::toRoom("Sculpt");
	// add new volume
	auto current = coat::Scene::sculptRoot().addChild("Wind rose");
	auto volume = current.Volume();
	// turn to surface
	volume.toSurface();
	float height = 100;
	float radius = 20;
	coat::cone cone1(height,radius);
	coat::cone cone2(height/2,radius/2);
	coat::mat4 matrix = coat::mat4::Identity;
	for (int i = 0; i < 4; i++){
		float alpha = i*90;
		matrix = coat::mat4::RotationZ(alpha);
		cone1.transform(matrix).details(0.5).add(volume);
		matrix = coat::mat4::RotationZ(alpha+45);
		cone2.transform(matrix).details(0.5).add(volume);
	}
	return 0;
}