//This example generates the surface figure "olimpic rings" that consists of toruses
#include <CoreAPI.h>

#define OUT_RADIUS 50
#define SEC_RADIUS 5
#define N 5

const coat::vec3 cpoints[N] = {coat::vec3(0,0,0),
							   coat::vec3(2*OUT_RADIUS+OUT_RADIUS/4,0,0),
							   coat::vec3(4*OUT_RADIUS+OUT_RADIUS/2,0,0),
							   coat::vec3(OUT_RADIUS+OUT_RADIUS/8,-OUT_RADIUS,0),
							   coat::vec3(3*OUT_RADIUS+3*OUT_RADIUS/8,-OUT_RADIUS,0)};
//@config: Debug
EXPORT
int main() {
	// get to sculpt room
	coat::ui::toRoom("Sculpt");
	// add new volume
	auto current = coat::Scene::sculptRoot().addChild("Olimpic rings");
	auto volume = current.Volume();
	// turn to surface
	volume.toSurface();
	float ringRadius = OUT_RADIUS;
	float crossSectionRadius = SEC_RADIUS;
	float rotate = 90;
	coat::torus torus(ringRadius,crossSectionRadius);
	// sets rings and slices
	torus.rings(16).slices(64);
	// get transform matrix 
	coat::mat4 matrix = torus.transform();
	// add  figures
	for(int i = 0; i < N; i++) {
		matrix.SetTranslation(cpoints[i]);
		torus.transform(matrix).add(volume);
	}
	return 0;
}