// This example generates the surface figure that consists of honey combs (ngons)
#include <CoreAPI.h>
//@config: Debug
class HoneyComb:public BaseClass {
public:
	HoneyComb() {
		Radius = 80;
		Height = 20;
		Fillet = 1;
		Size = 1;
	}
	float Radius;
	float Height;
	float Fillet;
	int Size;
	// this is class registration, look dialogs example
	SERIALIZE() {
		FSLIDER(Radius, "%Radius", 20, 100, 50, false);
		FSLIDER(Height, "%Height", 5, 20, 10, false);
		FSLIDER(Fillet, "%Fillet", 1, 5, 1, false);
		SLIDER(Size, "Size", 1, 10);
	}
	void build() {
		auto current = coat::Scene::sculptRoot().addChild("Honey comb");
		auto volume = current.Volume();
		float dx=Radius;
		float dy=Radius*sqrt(3.0);
		volume.toSurface();
		coat::ngon ng;
		ng.height(Height).radiusTop(Radius).radiusBottom(Radius).Obj<coat::ngon>().relativeHoleRadius(0).fillet(Fillet).details(0.2);
		for(int i=0;i<Size;i++)
			for(int j=i;j<Size;j++)
			  ng.translate(coat::vec3( (dx+dx/2)*i, 0, dy*i/2 + dy*(Size-1-j))).add(volume);
	}
};


EXPORT
int main() {
	// get to sculpt room
	coat::ui::toRoom("Sculpt");
	HoneyComb combs;
	coat::dialog dlg;
	// load settings if exist
	combs.ReadFromFile("data/Temp/HoneyComb.json");
	if(dlg.ok().cancel().params(&combs).show() == 1) {// ok pressed, buttons start from 1
		// save settings
		combs.WriteToFile("data/Temp/HoneyComb.json");
		// build the figure
		combs.build();
	};
	return 0;
}