// Generate the surface figure "brick wall" that consists of boxes
#include <CoreAPI.h>
//@config: Debug
EXPORT
int main() {
	// get to sculpt room
	coat::ui::toRoom("Sculpt");
	// add new volume
	auto current = coat::Scene::sculptRoot().addChild("Brick wall");
	auto volume = current.Volume();
	// turn to surface
	volume.toSurface();
	float sizeX = 100;
	float sizeY = 100;
	float sizeZ = 200;
	float _fillet = 10;
	float _detail = 0.2;
	int nrows = 3;
	int ncolumns = 3;
	//create default box
	coat::box bb1; // first brick box
	coat::box bb2; // second half brick box
	// set the size/fillet/details of the first box  
	bb1.size(coat::vec3(sizeX, sizeY, sizeZ)).fillet(_fillet).details(_detail);
	// set the size/fillet/details of the second box  
	bb2.size(coat::vec3(sizeX, sizeY, sizeZ/2)).fillet(_fillet).details(_detail);
	for (int i = 0; i < nrows; i++) {
		for (int j = 0; j < ncolumns; j++){
			if ( i % 2 == 0 ) {
				bb1.translate(coat::vec3(0,i*sizeY,j*sizeZ)).add(volume);
			} else {
				if ( j < ncolumns - 1){
					bb1.translate(coat::vec3(0,i*sizeY,j*sizeZ+sizeZ/2)).add(volume);
				} else {
					bb2.translate(coat::vec3(0,i*sizeY,-sizeZ/4)).add(volume);
					bb2.translate(coat::vec3(0,i*sizeY,j*sizeZ+sizeZ/4)).add(volume);
				}
			}
		}
	}
	return 0;
}