// Generate the figure that consists of multiple spheres merged into the single surface object without booleans
#include <CoreAPI.h>
//@config: Debug
// this is the class with parameters. It is used in UI and for the generating as well. Look the dialogs example.
class SpheresGenerator:public BaseClass {
public:
	SpheresGenerator() {
		numSpheres = 200;
		FigureRadius = 30;
		FigureRadiusVariation = 0.1;
		SpheresRadius = 10;
		SpheresRadiusVariation = 0.5;
	}
	int numSpheres;
	float FigureRadius;
	float FigureRadiusVariation;
	float SpheresRadius;
	float SpheresRadiusVariation;

	// this is class registration, look dialogs example
	SERIALIZE() {
		SLIDER(numSpheres, "numSpheres", 1, 1000);
		FSLIDER(FigureRadius, "FigureRadius", 1, 100, 1, false);
		FSLIDER(FigureRadiusVariation, "FigureRadiusVariation", 0, 1, 100, false);
		FSLIDER(SpheresRadius, "SpheresRadius", 1, 100, 1, false);
		FSLIDER(SpheresRadiusVariation, "SpheresRadiusVariation", 0, 1, 100, false);
	}
	// generate random value with variation
	float random(float value, float variation) {
		return value * (1.0f + variation * rand() / 32768.0f);
	}
	// generate the random surface spheres
	void generate() {
		// load the sphere mesh
		coat::Mesh m;
		m.Read("data/Samples/Sphere.obj");
		// add new volume
		auto current = coat::Scene::sculptRoot().addChild("Random spheres:" + coat::str::ToString(numSpheres));
		auto volume = current.Volume();
		// turn to voxels
		volume.toSurface();
		coat::Mesh summ;
		// collect all meshes into the single mesh
		for (int i = 0; i < numSpheres; i++) {
			// create transformation matrix.
			// scaling to the sphere radius
			coat::mat4 transform = coat::mat4::Scaling(random(SpheresRadius, SpheresRadiusVariation));
			// translate using the random vector
			transform *= coat::mat4::Translation(coat::vec3::RandNormal() * random(FigureRadius, FigureRadiusVariation));
			// transform and add the mesh to the summary mesh
			summ.addTransformed(m, transform);
		}
		// merge the summary mesh into the scene
		volume.mergeMesh(summ, coat::mat4::Identity, coat::BOOL_MERGE);
	}
};

EXPORT
int main() {
	// get to sculpt room
	coat::ui::toRoom("Sculpt");
	// create the generator object
	SpheresGenerator sg;
	coat::dialog dlg;
	// load generator settings if exist
	sg.ReadFromFile("data/Temp/Spheres.json");
	if(dlg.ok().cancel().params(&sg).show() == 1) {// ok pressed, buttons start from 1
		// save settings
		sg.WriteToFile("data/Temp/Spheres.json");
		// generate the figure
		sg.generate();
	};
	return 0;
}