// Vertex shader

uniform mat4 g_TextureMatrix0;
uniform mat4 g_TextureMatrix1;
uniform vec3 g_ViewerPos;
uniform float ViewBias;
uniform mat4 Transform;
uniform float TileFactor;

#ifdef SCREEN_SPACE
uniform mat4 g_WorldMatrix;
uniform mat4 g_ScreenMatrixInverse;
#endif

#ifdef WORLD_SPACE
uniform mat4 g_WorldViewProjectionMatrix;
#endif

in vec3 Pos;
in vec2 TexCoord;
in vec4 Color;
in vec4 Specular;



out vec3 oN;
out vec2 oUV;
out vec4 oC;
out vec3 oVDir;


// Used in included "ggx_variables" and "ggx_light_core"
out vec3 oRawNormal;
out vec3 oRawPos;

void main() {
	//vec3 D=normalize(g_ViewerPos-Pos);
	oUV = TexCoord*TileFactor;
	vec3 inN = Specular.xyz*2.0-1.0;
	vec4 P = vec4(Pos,1.0);
	vec4 N = vec4(inN,0.0);
	P = P * Transform;
	vec3 D=normalize(g_ViewerPos-Pos);
	P.xyz+=ViewBias*D;
	P = P * g_WorldViewProjectionMatrix;
	oVDir = normalize(Pos.xyz-g_ViewerPos);
	inN = (N * Transform).xyz;
	oN = normalize(inN);
	oC = Color;	
	gl_Position = P;
    oRawNormal = vec3(0.0);
    oRawPos = vec3(0.0);
}



// Fragment shader

in vec3 oN;
in vec2 oUV;
in vec4 oC;
in vec3 oVDir;
out vec4 FragColor;

uniform sampler2D s_Sampler0;
uniform float Opc;
uniform sampler2D Panorama;
uniform float PanoramaShift;
uniform float RefShade;
uniform mat4 g_NormalViewMatrix;
uniform vec3   LDir;
uniform vec3   LDir2;
uniform float    LDiffuseC;
uniform float    LDiffuse22C;
uniform float    LAmbient;
uniform float    FreezeInv;
uniform vec4   LightColor;
uniform mat3 WPanMatrix;
uniform float 	 Denorm;




#include "/Templates/ggx_variables.glsl"
#include "/Templates/contrast.glsl"

#define NO_FREEZE
#define TC_DEFINED

void main() {
	
	vec4 sfColor = oC;
	sfColor.xyz *= texture(s_Sampler0,oUV).xyz;
	float Opp = oC.w;
	sfColor.w = 0.0;
	float ExtraGloss=0.33;
	float Metalness=0.0;
	vec4  sfSpecular = vec4(ExtraGloss,0.0,Metalness,0.0);
	vec3  GlobalNormal=normalize(oN);
	vec3 ViewDir=normalize(oVDir);
	float Opacity = 1.0;
	vec4 Color = vec4(0.0);//sfColor;
	Color.w = 0.0;
	vec3  Normal    = GlobalNormal;
	vec3  ReflectionDir = normalize(ViewDir-2.0*Normal*dot(ViewDir,Normal));
	
	ReflectionDir = normalize(ReflectionDir * WPanMatrix);
	Normal  = normalize(Normal * WPanMatrix);
	ViewDir = normalize(oVDir * WPanMatrix);
	float Emissive = 0.0;

#include "/Templates/ggx_layers.glsl"
#include "/Templates/ggx_light_core.glsl"
	color.w = Opp*Opc;
	
	
	FragColor = color;
}
