// Vertex shader

uniform mat4 g_TextureMatrix0;
uniform mat4 g_TextureMatrix1;
uniform float ShiftT;

#ifdef SCREEN_SPACE
uniform mat4 g_WorldMatrix;
uniform mat4 g_ScreenMatrixInverse;
#endif

#ifdef WORLD_SPACE
uniform mat4 g_WorldViewProjectionMatrix;
#endif

in vec3 Pos;
in vec4 Color;
in vec2 TexCoord0;
in vec2 TexCoord1;

out vec4 v_Color;
out vec2 v_TexCoord0;
out vec2 v_TexCoord1;

void main() {
	v_TexCoord0 = vec2(vec4(TexCoord0, 0.0, 1.0) * g_TextureMatrix0);

#ifdef SCREEN_SPACE
	gl_Position = vec4(Pos, 1.0) * g_WorldMatrix * g_ScreenMatrixInverse;
#endif

#ifdef WORLD_SPACE
	gl_Position = vec4(Pos, 1.0) * g_WorldViewProjectionMatrix;
#endif
	v_TexCoord1.x = Pos.x/20.0+ShiftT;
	v_TexCoord1.y = Pos.y/20.0-ShiftT;
	v_Color = Color;
}

// Fragment shader

in vec4 v_Color;
in vec2 v_TexCoord0;
in vec2 v_TexCoord1;

uniform sampler2D s_Sampler0;
uniform sampler2D s_Sampler1;
uniform sampler2D s_Sampler2;

uniform vec3 VDir;
uniform vec3 LDir;
uniform vec3 LDir2;
uniform float LDiffuse;
uniform float LAmbient;
uniform float FreezeInv;
uniform float FreezeMod;
uniform vec3 g_ViewerPos;

out vec4 FragColor;
void main() {
    vec4 nrm;
    vec3 N2;
    float friz;
    vec3 N;
    vec4 tex;
    vec4 ch;
    vec3 refl;
    float S;
    float D;
    float fr;
    float fr2;
    vec4 Color;

    nrm = texture( s_Sampler1, v_TexCoord0);
    N2 = ((nrm.xyz  * 2.00000) - 1.00000);
#ifdef FORDP
    friz = 1.01-nrm.z;
    N2.z=-1.0;//-sqrt(1.0-N2.x*N2.x-N2.y*N2.y);
//    N2.xyz=N2.yxz;
    N2.xyz=-N2.xyz;
#else
    friz = length(N2);
    N2/=friz;
#endif	
    N = N2;
    tex = texture( s_Sampler0, v_TexCoord0);
    ch = texture( s_Sampler2, v_TexCoord1);
    refl = (VDir - ((2.00000 * N) * dot( VDir, N)));
    S = max( 0.000000, dot( refl, LDir));
    D = max( 0.000000, (LAmbient + (LDiffuse * dot( N, LDir))));
//    S += (max( 0.000000, dot( refl, LDir2)) * 1.85000);
//    D += max( 0.000000, (dot( N, LDir2) * LDiffuse));
    fr = clamp( (friz * FreezeInv), 0.000000, 1.00000);
    fr2 = pow( S, (1.00000 + ((nrm.w  * nrm.w ) * 64.0000)));
    fr2 *= ((nrm.w  * fr) * fr);
    Color.zyx  = mix( ch.xyz , (((D * tex.xyz ) * 2.00000) + fr2), vec3( fr));
    Color.w  = tex.w ;
    FragColor = Color;
}