// Vertex shader

uniform float ScaleX;
uniform float ScaleY;
uniform float ShiftT;
uniform vec3 g_ViewerPos;
uniform mat4 g_WorldViewProjectionMatrix;

in vec3 Pos;
in vec3 Normal;
in vec2 TexCoord;

out vec2 UV;
out vec2 UV2;
out vec3 VDir;

#ifdef VERT_NORMAL
out vec3 Nrm;
#endif

void main( ) {
    vec4 fPos;
    VDir = normalize( (Pos.xyz  - g_ViewerPos) );
    fPos = ( vec4( Pos, 1.00000) * g_WorldViewProjectionMatrix );
    UV = TexCoord;
    UV.y = 1.0-UV.y;
    UV2.x = ((fPos.x  / fPos.w ) * ScaleX) + ShiftT;
    UV2.y = ((fPos.y  / fPos.w ) * ScaleY) - ShiftT;
#ifdef VERT_NORMAL
    Nrm=Normal;
#endif
    gl_Position = fPos;
}

// Fragment shader

uniform float FreezeInv;
uniform float LAmbient;
uniform float LDiffuse;
uniform vec3 LDir;
uniform vec3 LDir2;
uniform sampler2D s_Sampler0;
uniform sampler2D s_Sampler1;
uniform sampler2D s_Sampler2;
uniform sampler2D s_Sampler3;

in vec2 UV;
in vec2 UV2;
in vec3 VDir;

#ifdef VERT_NORMAL
in vec3 Nrm;
#endif

out vec4 FragColor;

#ifdef VIEW_ALL

void main( ) {
    vec4 nrm;
    vec3 N2;
    float friz;
    vec3 N;
    vec4 tex;
    vec4 ch;
    vec3 refl;
    float S;
    float D;
    float fr;
    float fr2;
    vec4 Color;

    nrm = texture( s_Sampler1, UV);
    N2 = ((nrm.xyz  * 2.00000) - 1.00000);
    friz = length( N2 );
    N2 /= friz;
    vec3 nd;
#ifdef VERT_NORMAL
    N = Nrm;
    nd = N;
#else
    N = N2;
    float d=nrm.w/1024.0;
    vec3 NL=texture( s_Sampler1, UV-vec2(d,0)).xyz*2.0-1.0;
    vec3 NR=texture( s_Sampler1, UV+vec2(d,0)).xyz*2.0-1.0;
    vec3 NU=texture( s_Sampler1, UV-vec2(0,d)).xyz*2.0-1.0;
    vec3 ND=texture( s_Sampler1, UV+vec2(0,d)).xyz*2.0-1.0;
    nd=normalize(NL+NR+NU+ND);
#endif
    tex = texture( s_Sampler0, UV);
    ch = texture( s_Sampler2, UV2);
    refl = (VDir - ((2.00000 * N) * dot( VDir, N)));
    S = dot( refl, LDir);
    D = LAmbient + (LDiffuse * dot( nd, LDir));
    S += clamp(dot( refl, LDir2) * 1.85000,0.0,1.0);
    D += clamp(dot( nd, LDir2) * LDiffuse,0.0,1.0);
    fr = clamp( (friz * FreezeInv), 0.000000, 1.00000);
    fr2 = pow( S*S, (0.5 + ((nrm.w  * nrm.w ) * 32.0000)));
    fr2 *= ((nrm.w  * fr) * fr);
    Color.xyz  = mix( ch.xyz , (((D * tex.xyz ) * 2.00000) + vec3(fr2,fr2,fr2)), vec3(fr));
    Color.w  = tex.w ;
    FragColor = Color;
}
#endif

#ifdef VIEW_NOFREEZE  
void main( ) {
    vec4 nrm;
    vec3 N2;
    float friz;
    vec3 N;
    vec4 tex;
    vec4 ch;
    vec3 refl;
    float S;
    float D;
    float fr;
    float fr2;
    vec4 Color;

    nrm = texture( s_Sampler1, UV);
    N2 = ((nrm.xyz  * 2.00000) - 1.00000);
    friz = length( N2 );
    N2 /= friz;
    vec3 nd;
#ifdef VERT_NORMAL
    N = Nrm;
    nd = N;
#else
    N = N2;
    float d=1.0/512.0;
    vec3 NL=texture( s_Sampler1, UV-vec2(d,0));
    vec3 NR=texture( s_Sampler1, UV+vec2(d,0));
    vec3 NU=texture( s_Sampler1, UV-vec2(0,d));
    vec3 ND=texture( s_Sampler1, UV+vec2(0,d));
    nd=normalize(NL+NR+MU+ND+N2+N2);
#endif
    tex = texture( s_Sampler0, UV);
    ch = texture( s_Sampler2, UV2);
    refl = (VDir - ((2.00000 * N) * dot( VDir, N)));
    S = dot( refl, LDir);
    D = LAmbient + (LDiffuse * dot( nd, LDir));
    S += clamp(dot( refl, LDir2)) * 1.85000,0.0,1.0);
    D += clamp(dot( nd, LDir2) * LDiffuse,0.0,1.0);
    fr = clamp( (friz * FreezeInv), 0.000000, 1.00000);
    fr2 = pow( S, (1.00000 + ((nrm.w  * nrm.w ) * 64.0000)));
    fr2 *= ((nrm.w  * fr) * fr);
    Color.xyz  = mix( ch.xyz , (((D * tex.xyz ) * 2.00000) + vec3(fr2,fr2,fr2)), vec3( fr));
    Color.w  = tex.w ;
    FragColor = Color;
}
#endif

#ifdef VIEW_ENV  
void main( ) {
    vec4 nrm;
    vec3 N2;
    float friz;
    vec3 N;
    vec4 tex;
    vec4 ch;
    vec3 refl;
    vec2 uvb;
    vec3 sky;
    float S;
    float D;
    vec4 Color;

    nrm = texture( s_Sampler1, UV);
    N2 = ((nrm.xyz  * 2.00000) - 1.00000);
    friz = length( N2 );
    N2 /= friz;
#ifdef VERT_NORMAL
    N = Nrm;
#else
    N = N2;
#endif
    tex = texture( s_Sampler0, UV);
    ch = texture( s_Sampler2, UV2);
    refl = (VDir - ((2.00000 * N) * dot( VDir, N)));
    uvb = vec2( ((refl.x  / 3.00000) + 0.500000), (0.500000 - (refl.y  / 3.00000)));
    sky = vec3( (texture( s_Sampler3, uvb) / 2.00000));
    S = clamp(dot( refl, LDir),0.0,1.0);
    sky += pow( S*S, (0.5 + ((tex.w  * tex.w ) * 32.0000)));
    D = clamp(LAmbient + (LDiffuse * dot( N, LDir)),0.0,1.0);
    Color.xyz  = (((D * tex.xyz ) * 2.00000) + (sky * nrm.w ));
    Color.w  = tex.w ;
    FragColor = Color;
}
#endif

#ifdef VIEW_COLOR
void main( ) {
    FragColor = texture( s_Sampler0, UV);
}
#endif

#ifdef VIEW_RELIEF
void main( ) {
    vec4 nrm;
    vec3 N2;
    float friz;
    vec3 N;
    vec4 tex;
    float D;
    vec4 Color;

    nrm = texture( s_Sampler1, UV);
    N2 = ((nrm.xyz  * 2.00000) - 1.00000);
    friz = length( N2 );
    N2 /= friz;
#ifdef VERT_NORMAL
    N = Nrm;
#else
    N = N2;
#endif
    tex = texture( s_Sampler0, UV);
    D =LAmbient + (LDiffuse * dot( N, LDir));
    D += clamp(dot( N, LDir2) * LDiffuse,0.0,1.0);
    Color.xyz  = vec3( D);
    Color.w  = tex.w ;
    FragColor = Color;
}
#endif

#ifdef VIEW_SPECULAR
void main( ) {
    vec4 t;
    vec4 n;

    t = texture( s_Sampler0, UV);
    n = texture( s_Sampler1, UV);
    FragColor = vec4( n.w , n.w , n.w , t.w );
}
#endif

