// Vertex shader

in vec3 Pos;
in vec4 Color;
in vec2 TexCoord0;
in vec2 TexCoord1;

out vec4 v_Color;
out vec2 v_TexCoord0;
out vec2 v_TexCoord1;

uniform vec3 ViewPos;


uniform sampler2D S_M;
uniform sampler2D S_Q1;
uniform sampler2D S_Q2;
uniform sampler2D S_Q3;
uniform sampler2D S_Q4;
uniform sampler2D S_N;
uniform sampler2D S_D;
uniform sampler2D ShadowSampler;


uniform sampler2D Panorama;

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_ScreenToWorldMatrix;

uniform mat4 mFrom;
uniform mat4 mRayDir;
uniform vec3 LDir;
uniform vec3 LDir2;
uniform float LDiffuseC;
uniform float LDiffuse22C;
uniform float LAmbient;

uniform float aSceneTime;

vec3 oVDir;

	#define SHADOWS
#include "/Templates/ggx_variables.glsl"
#include "/Templates/contrast.glsl"
uniform vec4 		LightColor;




void main() {
	v_TexCoord0 = TexCoord0;
	v_TexCoord1 = TexCoord1;
   	v_TexCoord0.y=1.0-v_TexCoord0.y;
   	v_TexCoord1.y=1.0-v_TexCoord1.y;

	float xPxSize = 1.0/vpWidth;
	float yPxSize = 1.0/vpHeight;
   	v_TexCoord0= max(min(v_TexCoord0, vec2(1.0-xPxSize, 1.0-yPxSize)), vec2(xPxSize, yPxSize));
 //  	v_TexCoord0= max(min(v_TexCoord0, vec2(0.99)), vec2(0.01));



	vec4 s_V6 = texture(S_D, v_TexCoord0);
	
	vec3 iWorldPos = s_V6.xyz;//ViewPos-ViewDir*s_V6.x;
	

	
	vec4 dPos = vec4(iWorldPos, 1.0) * g_WorldViewProjectionMatrix;
//	dPos.xyz += g_ScreenToWorldMatrix[3].xyz;
/*	
	vec4 pxSSPos4 = vec4(iWorldPos, 1.0) * g_WorldViewProjectionMatrix; 
	vec2 pxSSUV = pxSSPos4.xy/pxSSPos4.w*0.5+vec2(0.5, 0.5); 

	vec4 vTestToWorld = (vec4(pxSSUV.x*2.0-1.0, fract(100.0+pxSSUV.y)*2.0-1.0, 1.0, 1.0) * g_ScreenToWorldMatrix);
	vTestToWorld /= vTestToWorld.w;

	vec4 pxSSTestPos4 = vec4(vTestToWorld.xyz, 1.0) * g_WorldViewProjectionMatrix; 
	vec2 pxTestSSUV = pxSSTestPos4.xy/pxSSTestPos4.w*0.5+vec2(0.5, 0.5); 

	vec2 shiftX = vec2(pxSSUV.x-pxTestSSUV.x,0.0);

	//	vec4 depthRaw = texture(DepthSampler, pxSSUV+shiftX);
	
	vec4 dPos = vec4((pxSSUV+shiftX)*2.0-vec2(1.0,1.0), 1.0/pxSSPos4.z, 1.0);
	*/
	
	if(length(iWorldPos) < 0.00001){
		dPos = vec4((TexCoord1*2.0-vec2(1.0)), 1.0,1.0);
		dPos.y = -dPos.y;
//		dPos.z = 99999.0;
	}	
	gl_Position = dPos;//* g_WorldMatrix * g_ScreenMatrixInverse;
	dPos.y = -dPos.y;

	v_Color.xy = saturate((((TexCoord1*2.0-vec2(1.0)))-(dPos.xy/dPos.w))*32.0+vec2(0.5));
	v_Color.z = 0;//dPos.z;
}

// Fragment shader

in vec4 v_Color;
in vec2 v_TexCoord0;
in vec2 v_TexCoord1;


out vec4 FragColor;




void main() {
//	FragColor = vec4(1,0,0.5,1);//vec4(v_Color.xyz,1.0);
	FragColor = vec4(v_Color.xyz,1.0);
}
