// Vertex shader

uniform mat4 g_WorldViewProjectionMatrix;
uniform vec3 g_ViewerPos;
uniform vec4 Sphere;

in vec3 Pos;
in vec3 Normal;
in vec2 Texcoord;

out vec3 v_Normal;
out vec3 VDir;

void main() {
	vec3 P=Sphere.xyz+Pos*Sphere.w;
	VDir = normalize(P-g_ViewerPos);
	v_Normal=Normal;
	gl_Position = vec4(P, 1.0) * g_WorldViewProjectionMatrix;
}

// Fragment shader

uniform vec3 LDir;
uniform vec4 Color;

in vec3 v_Normal;
in vec3 VDir;

out vec4 FragColor;
void main() {
	vec3 N;
	vec3 refl;
	float S;
	float D;
	vec4 C;
	N = normalize(v_Normal);
	refl = VDir-2.0*N*dot(VDir,N);
	S = dot(refl,LDir);
	S*=S;
	D = dot(N,LDir);
	D*=D;
	C.xyz = D*Color.xyz*2.0+pow(S,8.0);
   	C.w   = Color.w;
	FragColor = C;
}