// Vertex shader
uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 uvTrans1;
uniform mat4 uvTrans2;

in vec3 Pos;
in vec3 Normal;

out vec3 N;
out vec2 uv1;
out vec2 uv2; 

void main(){
	vec4 P = vec4(Pos, 1.0);
	gl_Position = P * g_WorldViewProjectionMatrix;
	N = Normal;
	vec4 u = P * uvTrans1;
	uv1 = vec2(u.x,1.0-u.y);
	u = P * uvTrans2;
	uv2 = vec2(u.x,1.0-u.y);
}

// Fragment shader

in vec3 N;
in vec2 uv1;
in vec2 uv2; 


uniform float LDiffuse;
uniform float LAmbient;
uniform vec3 LDir;
uniform vec4 CurrColor;
uniform sampler2D s_Sampler0;
uniform sampler2D s_Sampler1;

void In01(vec2 v){
	if(v.x*(1.0-v.x)<-0.0 || v.y*(1.0-v.y)<0.0)discard;
}
out vec4 FragColor;
void main(){
	float  D = -dot(N,LDir);	
	vec4 C=vec4(D);
	C.w=1.0;
	vec4  C14=texture(s_Sampler0,uv1);
	vec4  C24=texture(s_Sampler1,uv2);

	In01(uv1);
	In01(uv2);

	float C1=C14.y*C14.w;
	float C2=C24.y*C24.w;
	if(C1<0.5)C1=0.0;
	else C1=1.0;
	if(C2<0.5)C2=0.0;
	else C2=1.0;

	C.w*=C1*C2;
	if(C.w==0.0)discard;
	FragColor = C;
}
