// Vertex shader

uniform mat4 g_ViewProjectionMatrix;
uniform mat4 g_WorldMatrix;
uniform vec3 g_ViewerPos;
uniform mat4 g_NrmMatrix;

in vec3 Pos;
in vec3 Normal;
in vec4 Color;

out vec3 v_Normal;
out vec3 VDir;
out vec4 v_Pos2;

void main() {
	vec4 P=vec4(Pos,1.0);
	vec4 N=vec4(Normal,0.0);
	P=P * g_WorldMatrix;
	VDir = normalize(vec3(P)-g_ViewerPos);
	v_Normal=vec3(N * g_NrmMatrix);
	v_Pos2 = P * g_ViewProjectionMatrix;
	gl_Position = v_Pos2;
}

// Fragment shader

uniform vec3 LDir;
uniform vec4 Color;
uniform float g_ViewportWidth;
uniform float g_ViewportHeight;
uniform float Chess;

in vec3 v_Normal;
in vec3 VDir;
in vec4 v_Pos2;

out vec4 FragColor;
void main() {
	vec3 N;
	float D;
	vec4 C;
	N = normalize(v_Normal);
	D = dot(N,LDir);
	D*=D;
	D=0.2+D*0.8;
	C.xyz = D*Color.xyz*2.0;
   	C.w   = Color.w;
	
	vec4 p=v_Pos2;
	p/=p.w;
	float x=(1.0+p.x)*0.25*g_ViewportWidth+0.125;
	float y=(1.0+p.y)*0.25*g_ViewportHeight+0.125;
	float s=x+y;
	s-=floor(s);
	if(s>Chess){
		discard;
		C.w=0.0;
	}
	FragColor = C;
}