// Vertex shader

uniform mat4 g_WorldViewProjectionMatrix;
uniform float ShiftT;
uniform float ScaleX;
uniform float ScaleY;
uniform vec3 g_ViewerPos;
uniform mat4 ShadowTM;

in vec3 Pos;
in vec4 TexCoord;
in vec3 N;
in vec4 T;
in vec4 B;

out vec2 oUV;
out vec2 oUV2;
out vec3 oVDir;
out vec3 oN;
out vec3 oT;
out vec3 oB;
out vec3 oWorldPos;

// Used in included "ggx_variables" and "ggx_light_core"
out vec3 oRawNormal;
out vec3 oRawPos;

void main()
{
	vec4 P = vec4(Pos, 1.0);
	oVDir = normalize(Pos.xyz - g_ViewerPos);
	P.xyz+=oVDir*0.08;
	vec4 finalPos = P * g_WorldViewProjectionMatrix;
	oUV  = TexCoord.xy;    //-float2(1.0/1024.0,1.0/1024.0);
	oUV.y = 1 - oUV.y;
	oUV2 = vec2( finalPos.x / finalPos.w * ScaleX + ShiftT, finalPos.y / finalPos.w * ScaleY - ShiftT );
	oN = N;
	oT = T.xyz * 2.0 - 1.0;
	oB = B.xyz * 2.0 - 1.0;
//#ifdef SHADOWS
//	oSPos = (P * ShadowTM).xyz;
//	oSPos.xy += vec2( 1.0 / 4096.0 , 1.0 / 4096.0);
//	oSPos.y = 1.0 - oSPos.y;
//#endif
	oWorldPos = Pos;
	gl_Position = finalPos;
    oRawNormal = vec3(0.0);
    oRawPos = vec3(0.0);
}

// Fragment shader

uniform sampler2D s_Sampler0;//Texture;
uniform sampler2D s_Sampler1;//Normals;
uniform sampler2D s_Sampler2;//Chess;
uniform sampler2D s_Sampler3;//Colored specular;
uniform sampler2D s_Sampler4;//Environment map;
uniform sampler2D Panorama;
uniform float PanoramaShift;

#ifdef SHADOWS
uniform sampler2D ShadowSampler;
#endif

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_NormalViewMatrix;
uniform vec3   LDir;
uniform vec3   LDir2;
uniform float    LDiffuseC;
uniform float    LDiffuse22C;
uniform float    LAmbient;
uniform float    FreezeInv;
uniform float    RefShade;
uniform vec4   LightColor;
uniform mat3 WPanMatrix;
uniform vec4 Freshnel;
uniform vec4 mip_ref;
uniform float Denorm;

in vec2 oUV;
in vec2 oUV2;
in vec3 oVDir;
in vec3 oN;
in vec3 oT;
in vec3 oB;

out vec4 FragColor;

#define oMPos oWorldPos
#define oSPos oWorldPos


#include "/Templates/ggx_variables.glsl"
#include "/Templates/contrast.glsl"

#ifdef VIEW_ALL
void main() 
{
	vec4  color;
	vec4  nrm = texture(s_Sampler1,oUV);   
	vec4  sfColor  = texture(s_Sampler0,oUV).zyxw;
	vec4  sfSpecular = texture(s_Sampler3,oUV).zyxw;

	if(sfColor.w<0.1)discard;
	vec3  GlobalNormal=vec3(nrm.x*2.0-1.0,0.0,nrm.y*2.0-1.0);
	GlobalNormal.y=sqrt(1.0-GlobalNormal.x*GlobalNormal.x-GlobalNormal.z*GlobalNormal.z);	
	vec3 nn=normalize(oN);
	vec3 tt=normalize(oT-nn*dot(oT,nn)*Denorm);
	vec3 bb=normalize(oB-(nn*dot(oB,nn)+tt*dot(oB,tt))*Denorm);
	GlobalNormal=normalize(nn*GlobalNormal.y-tt*GlobalNormal.x-bb*GlobalNormal.z);

	vec3 ViewDir=oVDir;
	
	float Freeze = nrm.z;
	vec3  Normal    = GlobalNormal;	
	vec4  Checker = texture(s_Sampler2,oUV2);
	vec3  ReflectionDir = normalize(ViewDir-2.0*Normal*dot(ViewDir,Normal));

	ReflectionDir = normalize(ReflectionDir*WPanMatrix);
	Normal    = normalize(Normal*WPanMatrix);
	ViewDir = normalize(oVDir*WPanMatrix);
	float Gloss = nrm.w;
	float Emissive = sfSpecular.w;
	vec3 LightDir = LDir;
	vec3 objcolor = vec3(LDiffuse22C);

#include "/Templates/ggx_light_core.glsl"

        if(ProjectorOpacity>0){
		vec4 pruv = vec4(oWorldPos,1.0) * ProjectorTM;
		pruv.y*=-1;
		vec4 prcl=texture(ProjectorSampler,pruv.xy/pruv.w)*2.0;
		color.xyz *= lerp(vec3(1.0,1.0,1.0),prcl.xyz,ProjectorOpacity);
	}

	FragColor = color;
}
#endif //VIEW_ALL


#ifdef VIEW_ENV
void main() 
{
	FragColor = LightColor;
}
#endif


#ifdef VIEW_COLOR
void main()
{
	vec4 Color;
	vec4 C = texture(s_Sampler0, oUV);
	vec4 S = texture(s_Sampler3, oUV);
	vec4 ch = texture(s_Sampler2, oUV2);
	vec4 nrm = texture(s_Sampler1, oUV);
	float friz = 1.01 - nrm.z;
	float fr=1.0 - saturate((1.0-friz)*FreezeMod);
	Color.zyx = mix(ch.xyz, C.xyz, fr);
	Color.w = C.w;
	if(Color.w<0.1)discard;
	FragColor = Color;
}
#endif


#ifdef VIEW_RELIEF
void main()
{
	vec4 Color;
	vec4 nrm = texture(s_Sampler1, oUV);   
	vec4 tex  = texture(s_Sampler0, oUV);
	tex.xyz = vec3(0.5);
	if (tex.w < 0.1)
		discard;
	vec3 N2 = vec3(nrm.x * 2.0 - 1.0, 0.0, nrm.y * 2.0 - 1.0);
	N2.y = sqrt(1.0 - N2.x * N2.x - N2.z * N2.z);
	N2 = normalize(N2);	
	vec3 nn = normalize(oN);
	vec3 tt = oT;
	vec3 bb = normalize(cross(nn, tt));
	N2 = nn * N2.y - tt * N2.x - bb * N2.z;
	
	float friz = 1.0 - nrm.z;
	vec3 N = normalize(N2);	
	vec4 ch = texture(s_Sampler2, oUV2);

	float D = max(0, LAmbient + LDiffuseC * dot(N, LDir));

	float fr=1.0 - saturate((1.0-friz)*FreezeMod);
	Color.zyx = mix(ch.xyz, vec3(D,D,D), fr);
	Color.w = tex.w;
	FragColor = Color;
}
#endif


#ifdef VIEW_SPECULAR
void main()
{
	vec4 Color;
	vec4 C = texture(s_Sampler0, oUV);
	vec4 nrm = texture(s_Sampler1, oUV);
	vec4 ch = texture(s_Sampler2, oUV2);
	vec4 cosp = texture(s_Sampler3, oUV);
	float friz = 1.01 - nrm.z;
	float fr=1.0 - saturate((1.0-friz)*FreezeMod);
	float ww=nrm.w;
	Color.zyx = vec3(ww,ww,ww);
	Color.xyz = mix(ch.xyz, Color.xyz, fr);
	Color.w = C.w;
	FragColor = Color;
}
#endif

#ifdef VIEW_ROUGH
void main()
{
	vec4 Color;
	vec4 C = texture(s_Sampler0, oUV);
	vec4 nrm = texture(s_Sampler1, oUV);
	vec4 ch = texture(s_Sampler2, oUV2);
	vec4 cosp = texture(s_Sampler3, oUV);
	float friz = 1.01 - nrm.z;
	float fr=1.0 - saturate((1.0-friz)*FreezeMod);
	float ww=1.0-nrm.w;
	Color.zyx = vec3(ww,ww,ww);
	Color.xyz = mix(ch.xyz, Color.xyz, fr);
	Color.w = C.w;
	FragColor = Color;
}
#endif

#ifdef VIEW_SPCOLOR
void main() 
{
	vec4 Color;
	vec4 C = texture(s_Sampler0, oUV);
	vec4 nrm = texture(s_Sampler1, oUV);
	vec4 ch = texture(s_Sampler2, oUV2);
	vec4 cosp = texture(s_Sampler3, oUV);
	float friz = 1.01 - nrm.z;
	float fr=1.0 - saturate((1.0-friz)*FreezeMod);
	//Specular.xyz = cosp.xyz;
	Color.zyx = mix(ch.xyz, cosp.xyz, fr);
	Color.w = C.w;
	FragColor = Color;
}
#endif
