// Vertex shader

uniform mat4  g_WorldViewProjectionMatrix;
uniform float ShiftT;
uniform float ScaleX;
uniform float ScaleY;
uniform vec3  g_ViewerPos;
uniform mat4  ShadowTM;

in vec3 Pos;
in vec3 Normal;
in vec2 TexCoord;

out vec2 oUV;
out vec2 oUV2;
out vec3 oVDir;
out vec3 wpos;

#ifdef VERT_NORMAL
	out vec3 oN;
#endif
#ifdef SHADOWS
	out vec3 oSPos;
#endif

// Used in included "ggx_variables" and "ggx_light_core"
out vec3 oRawNormal;
out vec3 oRawPos;
out vec3 oWorldPos;

void main(){
    vec4 oPos;
	oVDir = normalize(Pos - g_ViewerPos);
	wpos = Pos;
	vec4 P = vec4(Pos, 1.0);
	P.xyz+=oVDir*0.06;
	oPos = P * g_WorldViewProjectionMatrix;
	oUV = TexCoord;
	oUV.y = 1.0 - oUV.y;
	oUV2 = vec2(oPos.x / oPos.w * ScaleX + ShiftT, oPos.y / oPos.w * ScaleY - ShiftT);
#ifdef VERT_NORMAL
	oN=Normal.xyz;
#endif
#ifdef SHADOWS
	oSPos = (P * ShadowTM).xyz;
	oSPos.xy += vec2(1.0 / 4096.0 , 1.0 / 4096.0);
	oSPos.y = 1.0 - oSPos.y;
#endif
	gl_Position = oPos;
	oRawNormal = vec3(0.0);
    oRawPos = vec3(0.0);
    oWorldPos = vec3(0.0);
}


// Fragment shader

in vec2 oUV;
in vec2 oUV2;
in vec3 oVDir;
in vec3 wpos;
#ifdef VERT_NORMAL
	in vec3 oN;
#endif
#ifdef SHADOWS
	in vec3 oSPos;
#endif

uniform mat4  g_WorldViewProjectionMatrix;

uniform sampler2D s_Sampler0;//Texture
uniform sampler2D s_Sampler1;//Normals
uniform sampler2D s_Sampler2;//Chess
uniform sampler2D s_Sampler3;//Colored specular
uniform sampler2D s_Sampler4;//Environment map
uniform sampler2D Panorama;//Panorama
#ifdef SHADOWS
uniform sampler2D ShadowSampler;
#endif

uniform mat4  g_NormalViewMatrix;
uniform vec3  LDir;
uniform vec3  LDir2;
uniform float LDiffuseC;
uniform float LDiffuse22C;
uniform float LAmbient;
uniform float FreezeInv;
uniform float RefShade;
uniform vec4  LightColor;
uniform mat3  WPanMatrix;
uniform vec4 Freshnel;
uniform vec4 mip_ref;
out vec4 FragColor;

#include "/Templates/ggx_variables.glsl"
#include "/Templates/contrast.glsl"

#ifdef VIEW_ALL
void main() {
	
	vec4  sfColor = texture(s_Sampler0, oUV).zyxw;	
	vec4  nrm = texture(s_Sampler1, oUV);  
	vec4  sfSpecular = texture(s_Sampler3, oUV).zyxw; 
	vec3  GlobalNormal = nrm.xyz * 2.0 - 1.0;
	float Freeze = length(GlobalNormal);
	vec4 color;
	GlobalNormal /= Freeze;
#ifdef VERT_NORMAL
	vec3  Normal = normalize(oN);	
#else
	vec3  Normal = normalize(GlobalNormal);
#endif

	vec3 ViewDir = oVDir;
	
	vec4  Checker = texture(s_Sampler2, oUV2);
	vec3  ReflectionDir = normalize(ViewDir - 2.0 * Normal * dot(ViewDir, Normal));

	ReflectionDir = normalize(ReflectionDir * WPanMatrix);
	Normal = normalize(Normal * WPanMatrix);
	ViewDir = normalize(ViewDir * WPanMatrix);
	float Gloss = nrm.w;
	float Emissive = sfSpecular.w;
	vec3 LightDir = LDir;
	Freeze = saturate(1.0 - Freeze*1.5);
	vec3 objcolor = vec3(LDiffuse22C);

#include "/Templates/ggx_light_core.glsl"

        if(ProjectorOpacity>0){
		vec4 pruv = vec4(wpos,1.0) * ProjectorTM;
		pruv.y*=-1;
		vec4 prcl=texture(ProjectorSampler,pruv.xy/pruv.w)*2.0;
		color.xyz *= lerp(vec3(1.0,1.0,1.0),prcl.xyz,ProjectorOpacity);
	}
	FragColor = color;
}
#endif //VIEW_ALL

#ifdef VIEW_NOFREEZE
void main(){
	vec4  color;
	vec4  nrm = texture(s_Sampler1, oUV);
	vec3  N2 = nrm.xyz * 2.0 - 1.0;
	float friz = length(N2);
	N2 /= friz;
#ifdef VERT_NORMAL
	vec3  N = oN;
#else
	vec3  N = N2;
#endif
	vec4  tex  = texture(s_Sampler0, oUV);
	vec3  refl = oVDir - 2.0 * N * dot(oVDir, N);
	vec4  specc  = texture(s_Sampler3, oUV);

	float   S = max(0.0, dot(refl, LDir));
	float   D = max(0.0, LAmbient + LDiffuseC * dot(N, LDir));

	S += max(0.0,dot(refl, LDir2)) * 1.85;
	D += max(0.0,dot(N, LDir2) * LDiffuseC);
	D = max(D, specc.w * (LAmbient + LDiffuseC));

	float fr2 = pow(S,vec3(1.0+nrm.w*nrm.w*64.0));
	fr2 *= nrm.w;   
	color.xyz = (D * tex.xyz + fr2 * specc.xyz) * 2.0;
	color.w = tex.w;
	FragColor = color * LightColor;
}
#endif //VIEW_NOFREEZE

#ifdef VIEW_ENV
void main(){
	vec4  color;
	vec4  nrm = texture(s_Sampler1, oUV);   
	vec3  N2 = nrm.xyz * 2.0 - 1.0;
	float friz = length(N2);
	N2 /= friz;
#ifdef VERT_NORMAL
	vec3  N = oN;
#else
	vec3  N = N2;
#endif
	vec4  tex  = texture(s_Sampler0, oUV);
	vec4  ch = texture(s_Sampler2, oUV2);
	vec3  refl = oVDir - 2.0 * N * dot(oVDir, N);
	vec2  uvb = vec2(refl.x / 3.0 + 0.5, 0.5 + refl.y / 3.0);
	vec3  sky = texture(s_Sampler4, uvb).xyz * (tex.xyz + 1.0) / 4.0;
	vec4  specc = texture(s_Sampler3, oUV);

	float S = max(0.0, dot(refl, LDir));
	sky += pow(S,1.0 + tex.w * tex.w * 64.0);
	float D = max(specc.w * (LAmbient + LDiffuseC), LAmbient + LDiffuseC * dot(N, LDir));

	float fr = clamp(friz * FreezeInv,0.0,1.0);
	float fr2 = pow(S, 1.0 + nrm.w * nrm.w * 64.0);
	fr2 *= nrm.w * fr * fr;   
	color.xyz = mix(ch.xyz,(D * tex.xyz + sky * specc.xyz * nrm.w) * 2.0, fr);
	color.w = tex.w;
	FragColor = color * LightColor;
}
#endif //VIEW_ENV

#ifdef VIEW_COLOR
void main( ) {
   vec4 color;
	vec4 C = texture(s_Sampler0,oUV);
	vec4  ch = texture(s_Sampler2,oUV2);
	vec4  nrm = texture(s_Sampler1,oUV);
	vec3 N2 = ((nrm.xyz  * 2.00000) - 1.00000);
  float friz = length( N2 );
  float fr = clamp( (friz * FreezeInv), 0.000000, 1.00000);
	color.xyz = mix(ch.xyz,C.zyx, fr);
	color.w = C.w;
  FragColor = color;
}
#endif

#ifdef VIEW_RELIEF
void main(){
	vec4  color;
	vec4  nrm = texture(s_Sampler1, oUV);
	vec4  ch = texture(s_Sampler2, oUV2);
	vec3  N2 = nrm.xyz * 2.0 - 1.0;
	float friz = length(N2);
	N2 /= friz;
#ifdef VERT_NORMAL
	vec3 N = oN;
#else
	vec3 N = N2;
#endif
	float D = max(0.0, LAmbient + LDiffuseC * dot(N, -oVDir));
	D += max(0.0, dot(N , LDir2) * LDiffuseC);
	float fr = clamp(friz * FreezeInv, 0.0, 1.0);
	vec3 vdir=oVDir;
	vec3  refl = normalize(vdir - 2.0 * N * dot(vdir, N));
	refl = normalize(refl * WPanMatrix);
	float uu = atan(refl.z, refl.x) / 6.2831853;
	float vv = 0.5 + asin(refl.y) / 3.1415926 * (2048.0 - pow(2.0, 11.0)) / 2048;
	vec4 ref2 = textureLod(Panorama,vec2(uu,vv),11.0);
	FragColor = vec4(ref2.rgb*pow(D,2.0/2.2),1.0);
}
#endif //VIEW_RELIEF

#ifdef VIEW_SPECULAR
void main(){
	vec4 color;
	vec3 specular;
	vec4 c = texture(s_Sampler0, oUV);
	vec4 nrm = texture(s_Sampler1, oUV);
	vec4 ch = texture(s_Sampler2, oUV2);
	vec4 spc = texture(s_Sampler3, oUV);
	vec3 N2 = nrm.xyz * 2.0 - 1.0;
	float friz = length(N2);
	float fr = clamp(friz * FreezeInv,0.0,1.0);
	float ww=nrm.w;
	color.xyz = vec3(ww,ww,ww);
	color.w = c.w;
	FragColor = color;
}
#endif //VIEW_SPECULAR

#ifdef VIEW_ROUGH
void main(){
	vec4 color;
	vec3 specular;
	vec4 c = texture(s_Sampler0, oUV);
	vec4 nrm = texture(s_Sampler1, oUV);
	vec4 ch = texture(s_Sampler2, oUV2);
	vec4 spc = texture(s_Sampler3, oUV);
	vec3 N2 = nrm.xyz * 2.0 - 1.0;
	float friz = length(N2);
	float fr = clamp(friz * FreezeInv,0.0,1.0);
	float ww=1.0-nrm.w;
	color.xyz = vec3(ww,ww,ww);
	color.w = c.w;
	FragColor = color;
}
#endif //VIEW_ROUGH

#ifdef VIEW_SPCOLOR
void main(){
	vec4 color;
	vec3 specular;
	vec4 c = texture(s_Sampler0, oUV);
	vec4 nrm = texture(s_Sampler1, oUV);
	vec4 ch = texture(s_Sampler2, oUV2);
	vec4 spc = texture(s_Sampler3, oUV);
	vec3 N2 = nrm.xyz * 2.0 - 1.0;
	float friz = length(N2);
	float fr = clamp(friz * FreezeInv,0.0,1.0);
	color.xyz = mix(ch.xyz, spc.zyx, fr);
	color.w = c.w;
	FragColor = color;
}
#endif
