// Vertex shader

uniform mat4 g_TextureMatrix0;
uniform mat4 g_TextureMatrix1;

#ifdef SCREEN_SPACE
uniform mat4 g_WorldMatrix;
uniform mat4 g_ScreenMatrixInverse;
#endif

#ifdef WORLD_SPACE
uniform mat4 g_WorldViewProjectionMatrix;
#endif

in vec3 Pos;
in vec4 Color;
in vec2 TexCoord0;
in vec2 TexCoord1;

out vec4 v_Color;
out vec2 v_TexCoord0;

void main() {
	v_TexCoord0 = TexCoord0;
	v_TexCoord0.y=1.0-v_TexCoord0.y;

#ifdef SCREEN_SPACE
	gl_Position = vec4(Pos, 1.0) * g_WorldMatrix * g_ScreenMatrixInverse;
#endif

#ifdef WORLD_SPACE
	gl_Position = vec4(Pos, 1.0) * g_WorldViewProjectionMatrix;
#endif

	v_Color = Color;
}

// Fragment shader

in vec4 v_Color;
in vec2 v_TexCoord0;

uniform sampler2D s_Sampler0;
uniform sampler2D s_Sampler1;

uniform vec4 TFactor;
uniform float Gamma;
uniform float Falloff;

out vec4 FragColor;
void main() {
	vec4 tex=texture(s_Sampler0,v_TexCoord0);
	vec4 C=v_Color;
	C.zy-=vec2(0.5);
	float L=length(C.zy);
	C.zy/=L;   
	L*=2.0;
	L=pow(L,Gamma);
	C.z*=L/2.0;         
	C.y*=L/2.0;
	vec4 tex2=texture(s_Sampler1,vec2(0.5)+(C.zy));
	tex2.w*=0.5*pow(1.0-L*L,Falloff*8.0);
	tex2.xyz*=tex.xyz;
	FragColor = tex2;
}