// Vertex shader

uniform mat4 g_TextureMatrix0;
uniform mat4 g_TextureMatrix1;

#ifdef SCREEN_SPACE
uniform mat4 g_WorldMatrix;
uniform mat4 g_ScreenMatrixInverse;
#endif

#ifdef WORLD_SPACE
uniform mat4 g_WorldViewProjectionMatrix;
#endif

in vec3 Pos;
in vec4 Color;
in vec2 TexCoord0;
in vec2 TexCoord1;

out vec4 v_Color;
out vec2 v_TexCoord0;
out vec2 v_TexCoord1;

void main() {
	v_TexCoord0.x = TexCoord0.x;
	v_TexCoord0.y = 1.0-TexCoord0.y;
	v_TexCoord1.x = TexCoord1.x;
	v_TexCoord1.y = 1.0-TexCoord1.y;

#ifdef SCREEN_SPACE
	gl_Position = vec4(Pos, 1.0) * g_WorldMatrix * g_ScreenMatrixInverse;
#endif

#ifdef WORLD_SPACE
	gl_Position = vec4(Pos, 1.0) * g_WorldViewProjectionMatrix;
#endif

	v_Color = Color;
}

// Fragment shader

in vec4 v_Color;
in vec2 v_TexCoord0;
in vec2 v_TexCoord1;

uniform sampler2D s_Sampler0;
uniform sampler2D s_Sampler1;

uniform vec4 TFactor;
uniform float Gamma;
uniform float Falloff;
uniform float InvMask;
uniform float ClampTex0;
uniform float ClampTex1;

out vec4 FragColor;
void main() {
   float d=v_TexCoord0.x*(1.0-v_TexCoord0.x)*ClampTex0;
   if(d<0.0)discard;
   d=v_TexCoord0.y*(1.0-v_TexCoord0.y)*ClampTex0;
   if(d<0.0)discard;

   d=v_TexCoord1.x*(1.0-v_TexCoord1.x)*ClampTex1;
   if(d<0.0)discard;
   d=v_TexCoord1.y*(1.0-v_TexCoord1.y)*ClampTex1;
   if(d<0.0)discard;

   vec4 T=texture(s_Sampler0,v_TexCoord0);
   vec4 T1=texture(s_Sampler1,v_TexCoord1);
   T.w*=(InvMask+(1.0-2.0*InvMask)*T1.y)*TFactor.w;
   FragColor = T;
}