// Vertex shader

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 ShadowTM;
uniform vec3 g_ViewerPos;

in vec3 Pos;
in vec3 Normal;
in vec4 Color;

out float v_pz;

void main() {
	vec4 P = vec4(Pos, 1.0);
	P *= ShadowTM;
	v_pz = P.z;
	gl_Position = P;
}

// Fragment shader

in float  v_pz;
       
out vec4 FragColor;
void main() {
    float Depth = v_pz;
    vec4 c = vec4(0.0, 0.0, 0.0, 1.0);
    float i = floor(Depth * 255.0);
    c.r = i / 255.0;
    Depth = (Depth - c.r) * 255.0;
    i = floor(Depth * 255.0);
    c.g = i / 255.0;
 
    FragColor = c;
}