// Vertex shader
uniform mat4 g_WorldViewProjectionMatrix;

in vec3 Pos;
in vec3 Normal;

out float v_pz;

void main() {
	vec4 P = vec4(Pos, 1.0);
	P *= g_WorldViewProjectionMatrix;
	v_pz = P.z/8000.0;
	gl_Position = P;
}

// Fragment shader

in float  v_pz;

out vec4 FragColor;
void main() {
    float Depth = v_pz;
    vec4 c = vec4(0.0, 0.0, 0.0, 1.0);
    float i = floor(Depth * 255.0);
    c.r = i / 255.0;
    Depth = (Depth - c.r) * 255.0;
    i = floor(Depth * 255.0);
    c.g = i / 255.0;
    Depth = (Depth - c.g) * 255.0;
    i = floor(Depth * 255.0);
    c.b = i / 255.0;
 
    FragColor = c;
}