// Vertex shader
#define AOPASS
uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldMatrix;
uniform float ShiftT;
uniform float ScaleX;
uniform float ScaleY;
uniform vec3 g_ViewerPos;
uniform mat4 ShadowTM;

uniform mat4 TransformInv;
uniform mat4 Transform;

//VS_INPUT
	in vec3 Pos;
	in vec2 Texcoord;
	in vec4 Color;
	in vec4 N;
	in vec4 T;
//VS_OUTPUT
	out vec4 oPos; 
	out vec4 oColor;
	out vec2 oUV;   
	out vec2 oUV2;  
	out vec3 oVDir; 
	out vec3 oN;    
	out vec4 oT;    
	out vec3 oWorldPos; 
	out float oOp;
	out float oFreeze;
	out vec3 oRawPos;
	out vec3 oRawNormal;


void main()
{
	vec4 P 	= vec4(Pos,1.0);
	vec4 iWorldPos = P*Transform;
	oWorldPos = iWorldPos.xyz;
	oVDir 	= normalize((iWorldPos.xyz-g_ViewerPos)*mat3(TransformInv));
	oPos 	= P * g_WorldViewProjectionMatrix;
	vec4 UVProjPos 	= iWorldPos * g_WorldViewProjectionMatrix;
	oUV 	= Texcoord.xy;
	oUV2 	= vec2(oPos.x/oPos.w*ScaleX+ShiftT,oPos.y/oPos.w*ScaleY-ShiftT);
	oN	= N.xyz*2.0-1.0039;
	oT.xyz	= T.xyz*2.0-1.0039;
	oT.w	= T.w*2.0-1.0;
	oColor	= Color;
	oOp = 0.0;
	oFreeze = N.w;
	if(oColor.w>0.01)oOp = 1.0;
	gl_Position = oPos;
	oRawPos = vec3(0);
	oRawNormal = vec3(0);
}    
	
// Pixel shader
#define AOPASS
	in vec4 oPos; 
	in vec4 oColor;
	in vec2 oUV;   
	in vec2 oUV2;  
	in vec3 oVDir; 
	in vec3 oN;    
	in vec4 oT;    
	in float oOp;
	in float oFreeze;
	
out vec4 FragColor;

uniform mat4 g_WorldViewProjectionMatrix;
	
uniform mat4 TransformInv;
uniform mat4 Transform;
	
uniform sampler2D s_Sampler0;//Texture;
uniform sampler2D s_Sampler1;//Normals;
uniform sampler2D s_Sampler2;//Chess;
uniform sampler2D s_Sampler3;//Colored specular;
uniform sampler2D s_Sampler4;//Environment map;
uniform sampler2D Panorama;
uniform sampler2D s_FreezeMask;
uniform float PanoramaShift;
uniform	float RefShade;
uniform float GlossInv;
	
#ifdef SHADOWS
uniform sampler2D ShadowSampler;
#endif	
	
uniform mat4 g_NormalViewMatrix;
uniform vec3  LDir;
uniform vec3  LDir2;
uniform float LDiffuseC;
uniform float LDiffuse22C;
uniform float LAmbient;
uniform float FreezeInv;
uniform vec4 LightColor;
uniform mat3 WPanMatrix;
uniform vec4 Freshnel;
uniform vec4 mip_ref;
uniform float Denorm;
uniform float fBumpness;	
uniform float fGlossMod;
uniform float fMetallMod;
uniform float fClip;
uniform mat3 g_ViewWorldMatrix3;	
	
#define NO_FREEZE
#define TC_DEFINED
//#define MODULATE_COLOR
#define MODULATE_GM
#define SPOS_IN_PIXEL_SHADER
#define ALPHAPOWER
#include "/Templates/ggx_variables.glsl"
#include "/Templates/contrast.glsl"
	
float dis(float x){
	return (x * 2.0 - 1.00392)*fBumpness;
} 
	
void main() 
{
	if(fClip*min(oUV.x*(1.0-oUV.x), oUV.y*(1.0-oUV.y)) < -0.0001)discard;
	vec4 nrm = texture(s_Sampler1,oUV);
	vec4  sfColor  =  texture(s_Sampler0,oUV);//-textureLod(s_Sampler0,oUV, 7);//+vec4(1.0,1.0,1.0,1.0);
	//sfColor = sfColor - textureLod(s_Sampler0,oUV, 7);//+vec4(1.0,1.0,1.0,1.0);
	vec4  sfSpecular = texture(s_Sampler2,oUV);
	//sfSpecular = sfSpecular - textureLod(s_Sampler0,oUV, 7)+vec4(1.0,1.0,1.0,1.0);
	sfSpecular.y = GlossInv+sfSpecular.y*fGlossMod*(1.0-GlossInv*2.0);
	float   metl = texture(s_Sampler3,oUV).y;
	
	float a = saturate(oColor.w/(oOp+0.001));
	float x = oOp;
	float mm = saturate(1.0-pow(1.01-a,x)*sfColor.w);
	nrm.w = 0;
	sfColor.xyz *= oColor.zyx*2.0;

	//vec4 frz = texture(s_FreezeMask, vec2(0.01 + oFreeze*0.98, 0.0));
	//sfColor.xyz *= lerp(vec3(1.0), frz.xyz, frz.w*0.7);

//	sfColor.xyz += oColor.zyx;
	float alp0 = mm;
	//sfColor.w=1.0;

#ifdef AOPASS
	float AlphaPower=2.0;
#else
	float AlphaPower=1.0 ;
#endif	
	vec3  GlobalNormal = normalize(vec3(dis(nrm.x),nrm.z*2.0 - 1.00392,dis(nrm.y)));
	vec3 nn = normalize(oN);
	vec3 tt = normalize(oT.xyz-nn*dot(oT.xyz,nn));
	vec3 bb = cross(tt,nn)*oT.w;
	bb = normalize(bb-nn*dot(bb,nn)-tt*dot(bb,tt));
	GlobalNormal = normalize(nn * GlobalNormal.y + tt * GlobalNormal.x - bb * GlobalNormal.z);
	vec3  Normal = GlobalNormal;	
 	vec3 ViewDir = oVDir;
	
	vec3 ReflectionDir = normalize(ViewDir-2*Normal*dot(ViewDir,Normal));
	ReflectionDir = normalize(ReflectionDir * WPanMatrix);
	Normal = normalize(Normal * WPanMatrix);
	ViewDir = normalize(oVDir * WPanMatrix);
	
	float Emissive = 0.5;//sfSpecular.w;
	float Opacity = sfColor.w;//*metl;
//	metl = 0;
	vec4 Color = sfColor;
	//Color.w=1.0;
	float GlossModulator=1.0;
	float MetallModulator=0.0;
	//sfColor.xyz *= sfColor.w;
	sfSpecular.w = sfSpecular.y;
	sfSpecular.z = metl * fMetallMod;
#define MC_COVER
#include "/Templates/ggx_layers.glsl"
	Emissive = 0.5;
#include "/Templates/ggx_light_core.glsl"
	color.w = Opacity*alp0;
	if(color.w<0.1)discard;
	FragColor = color;
}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
