// Vertex shader

uniform vec4 LT;
uniform vec4 RB;

in vec3 Pos;
in vec4 Color;
in vec2 TexCoord0;
in vec2 TexCoord1;

out vec4 v_Color;
out vec2 v_TexCoord0;

void main() {
	v_TexCoord0 = Pos.xy;
	v_TexCoord0.y = 1.0-v_TexCoord0.y;
	v_Color = Color;
	gl_Position = vec4(LT.x+Pos.x*(RB.x-LT.x),LT.y+Pos.y*(RB.y-LT.y),0,1);
}

// Fragment shader

in vec4 v_Color;
in vec2 v_TexCoord0;

uniform sampler2D s_Sampler0;

out vec4 FragColor;
void main() {
	vec4 c = texture(s_Sampler0, v_TexCoord0);
	FragColor = v_Color*c*2.0;
}