// Vertex shader

uniform mat4 g_TextureMatrix0;
uniform mat4 g_TextureMatrix1;

//#ifdef SCREEN_SPACE
uniform mat4 g_WorldMatrix;
uniform mat4 g_ScreenMatrixInverse;
//#endif

#ifdef WORLD_SPACE
uniform mat4 g_WorldViewProjectionMatrix;
#endif

in vec3 Pos;
in vec4 Color;
in vec2 TexCoord0;
in vec2 TexCoord1;

out vec4 v_Color;
out vec2 v_TexCoord0;
out vec2 v_TexCoord1;

void main() {
	v_TexCoord0 = vec2(vec4(TexCoord0, 0.0, 1.0) * g_TextureMatrix0);
	v_TexCoord1 = vec2(vec4(TexCoord1, 0.0, 1.0) * g_TextureMatrix1);
       	v_TexCoord0.y=1.0-v_TexCoord0.y;
       	v_TexCoord1.y=1.0-v_TexCoord1.y;


//#ifdef SCREEN_SPACE
	gl_Position = vec4(Pos, 1.0) * g_WorldMatrix * g_ScreenMatrixInverse;
//#endif

#ifdef WORLD_SPACE
	gl_Position = vec4(Pos, 1.0) * g_WorldViewProjectionMatrix;
#endif

	v_Color = Color;
}

// Fragment shader

in vec4 v_Color;
in vec2 v_TexCoord0;
in vec2 v_TexCoord1;

uniform vec3 ViewPos;


uniform sampler2D S_M;
uniform sampler2D S_Q1;
uniform sampler2D S_Q2;
uniform sampler2D S_Q3;
uniform sampler2D S_Q4;
uniform sampler2D S_N;
uniform sampler2D S_D;
uniform sampler2D S_SSDisplacement;
uniform sampler2D ShadowSampler;


uniform sampler2D Panorama;

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_ScreenToWorldMatrix;

uniform mat4 mFrom;
uniform mat4 mRayDir;
uniform vec3   LDir;
uniform vec3   LDir2;
uniform float    LDiffuseC;
uniform float    LDiffuse22C;
uniform float    LAmbient;

uniform float aSceneTime;

vec3 oVDir;

#ifdef UNPACK_PBM
	#define SHADOWS
#include "/Templates/ggx_variables.glsl"
#include "/Templates/contrast.glsl"
uniform vec4 		LightColor;

#else 
uniform sampler2D AScreenSampler;
uniform sampler2D DepthSampler;
uniform float CurrentIteration;
uniform float vpWidth;
uniform float vpHeight;
#endif

out vec4 FragColor;



#ifdef SS_EFFECTS

vec4 ScreenSpaceRayTrace(float aFromDepth, vec3 aFromPoint, vec3 aDirection, float aScatter, float aIterations, float aMinStepSize, float aAccuracy, float aRough){

	vec4 iHitResult = vec4(0.0, 0.0, 0.0, 0.0);
	bool iSSRayHit = false;
		vec3 dotRawDepth = vec3(1.0,1.0/255.0,1.0/255.0/255.0);

		vec4 pxSSPos4 = vec4(aFromPoint, 1.0) * g_WorldViewProjectionMatrix; 
		vec2 pxSSUV = pxSSPos4.xy/pxSSPos4.w*0.5+vec2(0.5, 0.5); 

		vec4 vTestToWorld = (vec4(pxSSUV.x*2.0-1.0, fract(100.0+pxSSUV.y)*2.0-1.0, 1.0, 1.0) * g_ScreenToWorldMatrix);
		vTestToWorld /= vTestToWorld.w;

		vec4 pxSSTestPos4 = vec4(vTestToWorld.xyz, 1.0) * g_WorldViewProjectionMatrix; 
		vec2 pxTestSSUV = pxSSTestPos4.xy/pxSSTestPos4.w*0.5+vec2(0.5, 0.5); 

		vec2 shiftX = vec2(pxSSUV.x-pxTestSSUV.x,0.0);

		//return texture(AScreenSampler, pxSSUV);
		//return vec4(texture(DepthSampler, pxSSUV).xyz,1.0);
		vec4 depthRaw = texture(DepthSampler, pxSSUV+shiftX);
		float pxDepth = aFromDepth;//dot(dotRawDepth, depthRaw.xyz)*65536.0;
		float pxDepthScale = 1.0;//pxSSPos4.z/pxDepth;

		vec3 iDirection = aDirection;//mix(aDirection, -ioRayDir.xyz, 0.3+aRough*aRough*0.7);
		vec4 v4Random = fract(abs(cos(vec4(CurrentIteration*61334.0, CurrentIteration*23244.0, CurrentIteration*35809.0, CurrentIteration*5242.0)+pxSSPos4.xyzy*1335.0+aDirection.yzxz*15140.0+aFromPoint.yzxz*5360.0)*(aScatter+1.0))*112.0)*2.0-vec4(1.0,1.0,1.0,1.0);
		vec3 inStep = normalize((aDirection)+v4Random.xyz*0.95*aScatter*mix(v4Random.w, 1.0, 0.35+(aScatter*aScatter+aScatter)*0.5*0.65));
		
		vec4 ssrPxPos4 = vec4(aFromPoint+inStep, 1.0) * g_WorldViewProjectionMatrix; 
		vec2 ssrPxUV = abs(pxSSUV-(ssrPxPos4.xy/ssrPxPos4.w*0.5+vec2(0.5, 0.5))); 
		float stepSize = 1.0/max(ssrPxUV.x*vpWidth, ssrPxUV.y*vpHeight);
		inStep *= stepSize*aMinStepSize;
		
		ssrPxPos4 = pxSSPos4;
		
		vec4 inStepExpo = vec4(inStep, length(inStep));
	
		vec2 ssrPxUVHit = ssrPxUV;
		float ssrPxDepth = aFromDepth;
		float ssrPxDepthPrev = ssrPxDepth;
		vec4 ssrPxPos4Prev = ssrPxPos4;
		float lRandom = (1.0+v4Random.w*aAccuracy);
		for(float i = 1; i < aIterations; i++){
			if(ssrPxPos4.z < 59999.0){
				ssrPxDepthPrev = ssrPxDepth;
				ssrPxPos4Prev = ssrPxPos4;
			}
			ssrPxPos4 = vec4(aFromPoint+inStepExpo.xyz*lRandom, 1.0) * g_WorldViewProjectionMatrix; 
			ssrPxUV = ssrPxPos4.xy/ssrPxPos4.w*0.5+vec2(0.5, 0.5); 

			vec4 ssrDepthRaw = texture(DepthSampler, ssrPxUV+shiftX);
			ssrPxDepth = dot(dotRawDepth, ssrDepthRaw.xyz)*65536.0;
			
	
			if(ssrPxPos4.z < 59999.0 && ssrPxDepth*pxDepthScale <= ssrPxPos4.z && (ssrPxPos4.z / pxSSPos4.z < ssrPxDepth / pxDepth * 1.2)){
				iSSRayHit = true;
				break;
			}
			inStepExpo = inStepExpo*(1.0+aAccuracy);
		}
		
		vec2 miZeroPos = ssrPxUV;
		
		float angleE = ((ssrPxDepth-pxDepth)*pxDepthScale) / (ssrPxPos4.z-pxSSPos4.z);
		bool isGoodAngle = (angleE > 0.80-aAccuracy*0.15);

		// get intersection point
		bool noDepthStep = abs(normalize(ssrPxPos4Prev.xyz-ssrPxPos4.xyz).z) < 0.5;
		float pxD1 = ssrPxDepthPrev*pxDepthScale-ssrPxPos4Prev.z;
		float pxD2 = ssrPxDepth*pxDepthScale-ssrPxPos4.z;
		float pxDE = pxD2/(pxD2-pxD1);
		vec4 ssrPxPos4Hit = mix(ssrPxPos4Prev, ssrPxPos4, 1.0-pxDE);

		vec2 ssrPxUV2 = ssrPxPos4Hit.xy/ssrPxPos4Hit.w*0.5+vec2(0.5, 0.5); 
		vec4 ssrDepthRaw = texture(DepthSampler, ssrPxUV2+shiftX);
		ssrPxDepth = dot(dotRawDepth, ssrDepthRaw.xyz)*65536.0;		

		float angleE2 = ((ssrPxDepth-pxDepth)*pxDepthScale) / (ssrPxPos4Hit.z-pxSSPos4.z);
		float ssrHitDepth = ssrPxDepth*pxDepthScale;
		bool isGoodAngle2 = (angleE2 > 0.80-aAccuracy*0.15) && (ssrHitDepth <= ssrPxPos4.z || ssrHitDepth <= ssrPxPos4Prev.z);
		if(isGoodAngle2 || noDepthStep) ssrPxUV = ssrPxUV2;
		
		if(iSSRayHit && (isGoodAngle || isGoodAngle2 || noDepthStep) && !(ssrPxUV.x < 0.0 || ssrPxUV.x > 1.0 || ssrPxUV.y < 0.0 || ssrPxUV.y > 1.0)){
			vec3 hitPoint = aFromPoint+inStepExpo.xyz*lRandom;
			
			vec4 ssrPxPosMip1 = vec4(hitPoint.x-inStepExpo.w, hitPoint.y, hitPoint.z, 1.0) * g_WorldViewProjectionMatrix;
			vec4 ssrPxPosMip2 = vec4(hitPoint.x, hitPoint.y-inStepExpo.w, hitPoint.z, 1.0) * g_WorldViewProjectionMatrix;
			vec4 ssrPxPosMip3 = vec4(hitPoint.x, hitPoint.y, hitPoint.z-inStepExpo.w, 1.0) * g_WorldViewProjectionMatrix;
			
			vec2 ssrPxPosMipSize = max(max(
											abs((ssrPxPosMip1/ssrPxPosMip1.w*0.5).xy+vec2(0.5, 0.5)-miZeroPos), 
											abs((ssrPxPosMip2/ssrPxPosMip2.w*0.5).xy+vec2(0.5, 0.5)-miZeroPos)), 
											abs((ssrPxPosMip3/ssrPxPosMip3.w*0.5).xy+vec2(0.5, 0.5)-miZeroPos)) * 0.03125 * aScatter;

			float mipSize = max(ssrPxPosMipSize.x, ssrPxPosMipSize.y);
				
			float iMipY = ssrPxUV.y-mipSize*2.0;
			//float pxMulF = 1.0/CurrentIteration;
			for(int iy = 0; iy < 5; iy++) {	
				float iMipX = ssrPxUV.x-mipSize*2.0;
				for(int ix = 0; ix < 5; ix++) {	
					vec4 mipSample = texture(AScreenSampler, saturate(vec2(iMipX, iMipY))+shiftX);//*pxMulF;
					//float iAlpha = saturate(mipSample.w);
					ssrDepthRaw = texture(DepthSampler, saturate(vec2(iMipX, iMipY))+shiftX);
					ssrPxDepth = dot(dotRawDepth, ssrDepthRaw.xyz)*65536.0;		
					if(ssrPxDepth > 59999.0) mipSample.w = 0;
					iHitResult += max(vec4(0.0,0.0,0.0,0.0),mipSample);
					//iHitResult.w += iAlpha;
					iMipX += mipSize;
				}
				iMipY += mipSize;
			}
			iHitResult.xyz *= 0.5+(1.0-saturate(aScatter))*0.5;
			
			iHitResult.xyz = saturate(iHitResult.xyz*0.01)*4.0;//texture(AScreenSampler, vec2(ssrPxUV.x, 1.0-ssrPxUV.y))/CurrentIteration;
			iHitResult.w = saturate(iHitResult.w*0.04);
//			iHitResult = texture(AScreenSampler, vec2(ssrPxUV.x, 1.0-ssrPxUV.y))/CurrentIteration;
		}

//	iHitResult.xyz = pow(iHitResult.xyz, vec3(2.2, 2.2, 2.2));
//	iHitResult.w = 1.0;
	return iHitResult;



//
}


#endif

void main() {
	
	float pxW = 1.25/vpWidth;
	float pxH = 1.25/vpHeight;
	
	vec4 s_VSSDisplacement = texture(S_SSDisplacement, v_TexCoord0);
	vec4 s_VSSDisplacementR = texture(S_SSDisplacement, vec2(v_TexCoord0.x+pxW, v_TexCoord0.y));
	vec4 s_VSSDisplacementB = texture(S_SSDisplacement, vec2(v_TexCoord0.x, v_TexCoord0.y+pxH));
	
	vec2 dCoord = v_TexCoord0 + (s_VSSDisplacement.xy-vec2(0.5))*0.03125*vec2(1.0,-1.0);
//	vec2 dCoordR = vec2(v_TexCoord0.x+pxW, v_TexCoord0.y) + (s_VSSDisplacementR.xy-vec2(0.5))*0.03125*vec2(1.0,-1.0);
//	vec2 dCoordB = vec2(v_TexCoord0.x, v_TexCoord0.y+pxH) + (s_VSSDisplacementB.xy-vec2(0.5))*0.03125*vec2(1.0,-1.0);
	vec2 dCoordR = vec2(v_TexCoord0.x+pxW, v_TexCoord0.y) + (s_VSSDisplacement.xy-vec2(0.5))*0.03125*vec2(1.0,-1.0);
	vec2 dCoordB = vec2(v_TexCoord0.x, v_TexCoord0.y+pxH) + (s_VSSDisplacement.xy-vec2(0.5))*0.03125*vec2(1.0,-1.0);
		
	vec4 s_V0 = texture(S_M, dCoord);
	vec4 s_V1 = texture(S_Q1, dCoord);
	vec4 s_V2 = texture(S_Q2, dCoord);
	vec4 s_V3 = texture(S_Q3, dCoord);
	vec4 s_V4 = texture(S_Q4, dCoord);
	vec4 s_V5 = texture(S_N, dCoord);
	
	vec4 s_V6 = texture(S_D, dCoord);
	vec4 s_V6R = texture(S_D, dCoordR);
	vec4 s_V6B = texture(S_D, dCoordB);
	
	vec3 DNormal = normalize(cross(s_V6.xyz - s_V6R.xyz, s_V6.xyz - s_V6B.xyz));
	
	
	
	vec4 c = texture(AScreenSampler, dCoord);


	vec3 dotRawDepth = vec3(1.0,1.0/255.0,1.0/255.0/255.0);
	vec4 depthRaw = texture(DepthSampler, v_TexCoord0);
	float pxDepth = dot(dotRawDepth, depthRaw.xyz)*65536.0;
		
	c.w=saturate(c.w*2.0);
	//vec4 c1 = texture(s_Depth, v_TexCoord1);	
	//c.xyz+=(c1.xyz-0.5)*2;

	vec4 vRayDir = (vec4(v_TexCoord0.x*2.0-1.0, fract(100.0+v_TexCoord0.y)*2.0-1.0, 1.0, 1.0) * g_ScreenToWorldMatrix);
	vRayDir /= vRayDir.w;
	vRayDir.xyz-=ViewPos;
	vRayDir.w = 0;
	
#ifdef NODE_CODE
	#define ioPanorama Panorama;
	ioCameraPosition = vec4(ViewPos, 0.0);
	
//	vec4 vFrom = mix(mix(mFrom[0],mFrom[1], v_TexCoord0.x),mix(mFrom[2],mFrom[3], v_TexCoord0.x), fract(100.0-v_TexCoord0.y)); 
//	vec4 vRayDir = mix(mix(mRayDir[0],mRayDir[1], v_TexCoord0.x),mix(mRayDir[2],mRayDir[3], v_TexCoord0.x), fract(100.0-v_TexCoord0.y)); 
	float uMod = sin(v_TexCoord0.y*3.14159);
	ioRayDir = normalize(-vRayDir);//-normalize(vec4(cos(v_TexCoord0.x*6.28319)*uMod,v_TexCoord0.y*2.0-1.0/*asin(1.0-oTexCoord.y*2.0)*0.318310*/, sin(v_TexCoord0.x*6.28319)*uMod, 0.0));
	////////////////////////////////////////////////
	ioResolution = vec4(4096.0, 2048.0, 0.0, 0.0);           // viewport resolution (in pixels)
	ioTime = vec4(aSceneTime);                 // shader playback time (in seconds)
	ioTimeDelta = 0.033*vec4One;            // render time (in seconds)
	ioFrame = vec4Zero;                // shader playback frame
	ioMouse = vec4Zero;                // mouse pixel coords. xy: current (if MLB down), zw: click
//	ioDate;                 // (year, month, day, time in seconds)
	ioFragCoord = v_TexCoord0.xyxy;
	ioPosition = v_TexCoord0.xyxy;
	ioNormal = vec4(0.0, 1.0, 0.0, 0.0);

	ioPM = vec4(c.xyz*0.5, c.w);
	ioPQ1 = vec4(0.5);
	ioPQ2 = vec4(0.0);
	ioPQ3 = vec4(0.5);
	ioPQ4 = vec4(0.5);
	ioPN = vec4(0.5, 0.5, 0.0, 0);

	ioDisplacement = vec4(pxDepth);//vec4Zero;

	NODE_CODE;


//	Normal.xyz = -ioNormal.xyz;

//	tSpecular = ioAlbedoColor.xyz*saturate(ioMetal.xyz);
	c.xyz = ioPM.xyz*2.0;
//	ioReflectionColor *= vec4One-saturate(ioMetal);
//	tColor = ioAlbedoColor.xyz;
//	tSpecular += ioReflectionColor.xyz;
//	Gloss = ioGloss.w;
//	Emiss = ioEmissive.xyz;
//	sfColor.w = ioOpacity.w;
#endif	

#ifdef UNPACK_PBM
	vec3 Normal = DNormal;//vec3((s_V5.x*2.0-1.0), (s_V5.y*2.0-1.0), (s_V5.z*2.0-1.0));
	vec3 GlobalNormal = Normal;
	vec3 ViewDir = normalize(-vRayDir.xyz);
	vec3 ReflectionDir = reflect(ViewDir, Normal);
//	vec3 ReflectionDir = normalize(ViewDir-2*Normal*dot(ViewDir,Normal));

	vec3 N0 = GlobalNormal;
	float RefShade = 1.0;
	oVDir = ViewDir;
	vec3 LightDir = LDir;


	vec4 color = s_V0;
	float Freeze = 0.0;
	
	s_V5.w = s_V5.y;
//	s_V5.z = 0.85;
//	s_V2.xyz = vec3(1,1,1);
	
	ViewDir = normalize(ViewDir);
	vec3 iWorldPos = s_V6.xyz;//ViewPos-ViewDir*s_V6.x;
	
//	s_V0.xyz = iWorldPos.xyz*0.01;
	
#define oWorldPos iWorldPos
	
//	#define USE_NORMALMAP_PPP
//	#define USE_NORMALMAP
//	#define USE_SSSHADOW
//	#define REFRACTION
	#define ARTISTIC
//	#define CLEAR_COAT
//	#define MICROPROTRUSIONS
//	#define FUZZ
//	#define PPP
	
	
//#define SSREFLECTIONS
//#define SSGI

	
#include "/Templates/pbm_light_core.glsl"
	
//	color.w = 1;
	vec4 dColor = s_VSSDisplacement;
	dColor.w = 1.0;
	FragColor = color;//pow(color, vec4(2.2));

return;
#endif	
	c.xyz = pow(c.xyz, vec3(2.2));//*pxDepth*0.001;

	FragColor = v_Color * c;
}
