// Vertex shader

in vec3 Pos;
in vec3 Normal;

out vec3 oN;
out vec3 oViewDir;

uniform mat4 g_WorldViewProjectionMatrix;
uniform vec3 g_LocalViewPos;

void main() {
	vec4 P = vec4(Pos, 1.0);
	oViewDir = normalize(Pos - g_LocalViewPos);
	oN = normalize(Normal);    
	// Calculate the final position in clip space
	vec4 pos = P * g_WorldViewProjectionMatrix;
    pos.z-=0.1;
	pos/=pos.w;
	gl_Position = pos;

}

// Geometry shader

layout(triangles) in;
layout(line_strip, max_vertices = 2) out;

in vec3 oN[];
in vec3 oViewDir[];

void main() {
    // Calculate dot products
    float dot0 = dot(oN[0], oViewDir[0]);
    float dot1 = dot(oN[1], oViewDir[1]);
    float dot2 = dot(oN[2], oViewDir[2]);

    // Check if any edge has different signs
    if ((dot0 * dot1) <= 0.001) {
        gl_Position = gl_in[0].gl_Position;
        EmitVertex();
        gl_Position = gl_in[1].gl_Position;
        EmitVertex();
        EndPrimitive();
    } else
	if ((dot1 * dot2) <= 0.001) {
        gl_Position = gl_in[1].gl_Position;
        EmitVertex();
        gl_Position = gl_in[2].gl_Position;
        EmitVertex();
        EndPrimitive();
    } else
	if ((dot2 * dot0) <= 0.001) {
        gl_Position = gl_in[2].gl_Position;
        EmitVertex();
        gl_Position = gl_in[0].gl_Position;
        EmitVertex();
        EndPrimitive();
    }
}


// Fragment shader

uniform vec4 wire_color;
uniform float GridConst; 

out vec4 FragColor;

void main() {
    if(mod(gl_FragCoord.x+gl_FragCoord.y,2.0)==GridConst)discard;
    FragColor = wire_color; // White color for contour lines
}
