// Vertex shader
#include "/Templates/scalc_vs.glsl"
// Fragment shader
#include "/Templates/scalc_variables.glsl"
#include "/Templates/scalc_voxel_lib.glsl"


uniform vec3 center;
uniform float radius;
uniform float degree;
uniform int sign;

void main() {
	int gx = int(gl_FragCoord.x);
	int gy = int(gl_FragCoord.y);	
	int base = gx+gy*LinearTexturePinch;
	ivec2 tsz = textureSize(out_BackIndex,0);
	float h=float(tsz.y);
	for(int i=0;i<2;i++){
		int ofs = base*2+i;
		ivec3 pos = getPos(ofs);
		float v0=getCellValue(pos.x, pos.y, pos.z);		
		int nn=2+int(clamp(degree*3, 0, radius / 10));
		if(sign != 0)nn = 3;
		float summ = getSmoothedValue(pos, nn);
		float r = distance(center, vec3(pos.x, pos.y, pos.z));
		float w = saturate(r/radius);
		w *= w;
		w = 1.0 - w;
		w *= w;
		float w1 = saturate(degree*w);
		float v = saturate((summ * w1 + v0 * (1.0 - w1)-0.5)*(1.0+w1/20.0) + 0.5);
		if(sign == 1) v = max(v, v0);
		if(sign == -1) v = min(v, v0);

		int val = int(v*65535.0);
		 
		if(i == 0) FragColor.xy = intTov2(val);
		else FragColor.zw = intTov2(val);		
	}
}
