// Vertex shader
#include "/Templates/scalc_vs.glsl"
// Fragment shader
#include "/Templates/scalc_variables.glsl"
#include "/Templates/scalc_voxel_lib.glsl"

uniform sampler2D verts;
uniform sampler2D normals;
uniform sampler2D NbIndex;
uniform sampler2D NB;
uniform int Count;

void main() {
	int gx = int(gl_FragCoord.x);
	int gy = int(gl_FragCoord.y);	
	int base = gx+gy*LinearTexturePinch;
	if(base>=Count) discard;
	vec4 res = getVec4(verts, base);
	vec3 baseN = normalize(getVec4(normals, base).xyz - vec3(0.5,0.5,0.5));

	int v0 = getInt(NbIndex, base);
	int v1 = getInt(NbIndex, base + 1);
	
	vec3 summ = vec3(0.0,0.0,0.0);
	if(base < Count){
		for (int k = v0; k < v1; k++) {
			int v = getInt(NB, k);
			vec3 norm = normalize(getVec4(normals, v).xyz - vec3(0.5,0.5,0.5));
			vec3 pos1 = getVec4(verts, v).xyz;
			vec3 d = pos1 - res.xyz;
			summ += baseN*dot(baseN, d + norm*dot(norm, d));
		}
	}
	res.xyz += summ / (v1 - v0 + 1) / 2;
	
	vec3 norm = getVec4(normals, base).xyz - vec3(0.5,0.5,0.5);
	norm = normalize(norm);
	//res.xyz += norm*0.0000000000001;


	FragColor = res;
}
