#define RP_COMPOSITE 0
#define RP_DIFFUSE 1
#define RP_TRANSLUCENT 2
#define RP_LIGHT 3
#define RP_AO 4
#define RP_DEPTH 5
#define RP_REFLECTION 6
#define RP_REFRACTION 7
#define RP_CLEAR_COAT 8
#define RP_GLOSS 9
#define RP_FOG 10
#define RP_FOG_MASK 11
#define RP_FOG_LIGHT 12
#define RP_EMMISIVE 13
#define RP_FUZZ 14
#define RP_FUZZ_MASK 15
#define RP_FUZZ_LIGHT 16
#define RP_MICROPROTRUSIONS 17
#define RP_MICROPROTRUSIONS_MASK 18
#define RP_MICROPROTRUSIONS_LIGHT 19

	const vec3 gamma = vec3(2.2); 
	const vec3 igamma = vec3(1.0/2.2); 

#if D_RRenderPass == RP_TRANSLUCENT || D_RRenderPass == RP_REFRACTION || D_RRenderPass == RP_CLEAR_COAT || D_RRenderPass >= RP_EMMISIVE
	FragColor = vec4(0, 0, 0, 1); 
	return;
#endif
	vec4 lightColor = mix(LightColor, LightColor2g, IsExternalLight);

	float fShadeSharp = pow(ShadeSharp, 2.0)*256;
	float fCurvatureSharp = pow(curvatureSharp, 2.0)*256;
	float fContourSharp = pow(ContourSharp, 2.0)*256;
	
	float fLightEnvMod = 1.0;//(1.0+IsExternalLight*10.0)/11.0;
	
	float de = saturate(pow((1.0/oExtra.w)*pow(FogDensity/1000.0,2.0),FogPower));
	float ffde = saturate(pow((1.0/oExtra.w)*pow((10-FrontFade)/100.0,2.0),FrontFadePower));

	
	float dotNV = saturate(abs(dot(Normal,ViewDir)));
	float fcontour = saturate(((1.0-dotNV)-(1.0-Contour))*fContourSharp);
	vec4 MColor = pow(mix(Color, Color*sfColor, alpha), vec4(2.2, 2.2, 2.2, 1.0));
	vec4 MContourColor = pow(mix(ContourColor, ContourColor*sfColor, alpha), vec4(2.2, 2.2, 2.2, 1.0));
	vec4 MShadowColor = pow(mix(ShadowColor, ShadowColor*sfColor, alpha), vec4(2.2, 2.2, 2.2, 1.0));
	
	color = MColor;
	
	float fSpecularRoughness = mix(SpecularRoughness, 1.0-pow(Gloss, SpecularRoughness*2.0)*0.99, alpha);	
	float fMetallness = mix(Metallness, Metall, alpha);	

#ifdef NODE_CODE
	#ifdef USE_CAVITY
		float icavity = -ca0*0.5+0.5;
		ioCavity = vec4(icavity, icavity, icavity, icavity);
	#else
		ioCavity = vec4(0.5,0.5,0.5,0.5);
	#endif
	ioTime = vec4(TimeSeconds, TimeSeconds, TimeSeconds, TimeSeconds);                 // shader playback time (in seconds)
	ioMouse = vec4(MousePos.x, MousePos.y, MousePos.z, 0.0);                // mouse pixel coords. xy: current (if MLB down), zw: click
	ioFragCoord = vec4(oMPos.xyz, 0.0);
	ioPosition = vec4(oWorldPos.xyz, 0.0);
	ioNormal = vec4(-Normal, 0.0);

	ioPM = vec4(tColor*0.5, sfColor.w);
	ioPQ1 = vec4(0.5);
	ioPQ2 = vec4(tSpecular.xyz, 0.0);
	ioPQ3 = vec4(0.0);
	ioPQ4 = vec4(0.5);
	ioPN = vec4(0.5, 0.5, 0.0, Gloss);
	ioDisplacement = 0;

	ioLightDir = vec4(LightDir.xyz, 0.0);
	ioCameraPosition = vec4(g_LocalViewPos.xyz, 0.0);
	ioIteration = vec4One * CurrentIteration;

	NODE_CODE;

	Normal.xyz = -ioNormal.xyz;

	Gloss = ioPN.w;
	ioPN.z = saturate(ioPN.z*2.0-1.0);

	tColor = ioPM.xyz*2.0*(1.0-ioPN.z);
	sfColor.w = ioPM.w;
	tSpecular.xyz = mix(ioPQ2.xyz, ioPM.xyz*2.0, ioPN.z);
	//Emiss = ioPQ3.xyz*2.0;
	
#endif


	vec3 dxx=dFdx(oN);
	vec3 dyy=dFdy(oN);//*IncSign;
	float dpv = saturate(dot(Normal,ViewDir));
	
	float fca0 = (CavityCo.x*oExtra.w+CavityCo.y)*(dot(dxx,LocalRightDir)-dot(dyy,LocalUpDir))*sqrt(dpv);
	float fcavity = saturate(((0.0-fca0)-(1.0-cavityIntensity))*fCurvatureSharp);
	float fbugle = saturate((fca0-(1.0-bulgeIntensity))*fCurvatureSharp);

	float fMultiplier = 1.0;
#ifdef SHADOWS	
	vec4 SPos4 = vec4(oWorldPos,1.0);
	SPos4 = SPos4*ShadowTM;
	SPos4.y = 1.0 - SPos4.y;
	vec3 SPos = SPos4.xyz;

	color = color*LightColor*fLightEnvMod;

	vec3 d = vec3(1.0,1.0/255.0,1.0/255.0/255.0);
	vec3 m = texture(ShadowSampler,SPos.xy).xyz;	
	
	float fshadowBias = 0.05/WShadowMapSize;	
	
	fMultiplier = saturate(2.0-(SPos.z-dot(m,d)-fshadowBias)*WShadowMapSize*2.0);
//	fMultiplier = saturate(20.0-(SPos.z-dot(m,d))*4000);

	#if D_RRenderPass == RP_AO
		FragColor = vec4(fMultiplier, fMultiplier, fMultiplier, 1); 
		return;
	#endif
	#if D_RRenderPass == RP_LIGHT
		FragColor = vec4(fMultiplier, fMultiplier, fMultiplier, 1)*LightColor*fLightEnvMod;
		return;
	#endif
	
	color = mix(color,MShadowColor,1.0-fMultiplier);
#else
	#if D_RRenderPass == RP_LIGHT
		FragColor = vec4(0, 0, 0, 1); 
		return;
	#endif
	
#endif	

	float fInvLambLightNV = saturate((1.0-dot(-GlobalNormal,LightDir))/2.0);
	color = mix(color,MShadowColor,1.0-saturate((fInvLambLightNV-(1.0-ShadeLight))*fShadeSharp));
	color = mix(color,MShadowColor,fMetallness);
	
	color = mix(color,MContourColor,fcavity);
	color = mix(color,MContourColor,fbugle);

	
	vec4 fSpecColor = mix(LightColor, MColor*LightColor*(5.8-pow(fSpecularRoughness, 0.25)*5.0), fMetallness);
	vec3 H = normalize(LightDir-oVDir); 
	float dotNL = saturate(dot(GlobalNormal,LightDir));
	float dotNH = saturate((dot(GlobalNormal,H) - (1.0-fSpecularRoughness))*mix(fShadeSharp, 256.0, pow(1.0-fSpecularRoughness, 20.0)));
	
	
#if D_RRenderPass == RP_REFLECTION
	color *= 0;
#endif
#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass == RP_REFLECTION
	color = mix(color,fSpecColor,dotNH*fMultiplier*mix(SpecularIntensity, 1.0, fMetallness)*mix(pow(1.0-fSpecularRoughness, 2.0), (pow(1.0-fSpecularRoughness, 2.0)+1.0)/2.0, fMetallness)*fLightEnvMod);
#endif
#if D_RRenderPass == RP_COMPOSITE || D_RRenderPass == RP_DIFFUSE
	color = mix(color,MContourColor,fcontour);
#endif
#if D_RRenderPass == RP_REFLECTION
	color = mix(color,MContourColor*0,fcontour);
#endif

	color = mix(color,FogColor,de);
	color = mix(vec4(0,0,0,1), color,ffde);



////////////////	
// FOG	////////
#ifdef IS_VOXEL_SHADER
	float Wde = saturate(pow((1.0/oExtra.w)*pow(WFogDensity/10000.0,2.0),WFogPower));
	
	#if D_RRenderPass == RP_DEPTH
		FragColor = vec4(Wde, Wde, Wde, 1.0); 
		return;
	#endif

	#if D_RRenderPass == RP_COMPOSITE || (D_RRenderPass >= RP_FOG && D_RRenderPass <= RP_FOG_LIGHT)
	
	   color.xyz = lerp(color.xyz,vec3(0,0,0),saturate(WSilhouette*Wde)).xyz;
	   color.xyz = lerp(color.xyz,vec3(0,0,0),saturate(WSilhouette/50.0-1.0)).xyz;

#ifdef SHADOWS	

	
	color.xyz = lerp(color.xyz,vec3(fMultiplier,fMultiplier,fMultiplier),WLightSilhouette/100.0).xyz;

	// FOG
#ifdef SPOS_IN_PIXEL_SHADER
#ifdef D_WFogDensity
	#ifdef D_WVolumeFogSamples


#define FOG_STEPS 32
		vec3 WOldSVPos = SPos.xyz;
		float WOldFogWde = pow((1.0/oExtra.w)*(WFogDensity/10000.0,2.0),WFogPower);
		float WFogWde = 0;
		float WFogStep = 1.0/FOG_STEPS;
		float WFogLerpPos = 0.0;
		float VSWdeDeltaSum = 0.0;
		float VSWdeDeltaWOShadowSum = 0.0;
//		int iWVolumeFogSamples = max(3,WVolumeFogSamples);
		
		vec3 WFogVolumeColorResult = vec3(0,0,0);
		
		
		for(int iVSS = 0; iVSS < FOG_STEPS; iVSS++){
			WFogLerpPos += WFogStep;
			float WFogLerpPosRand = WFogLerpPos-(WFogStep*WFogRand);
			
			vec4 zP = vec4(lerp(oPos.xyz , g_LocalViewPos.xyz,WFogLerpPos), 1.0);
			vec4 zPC = zP * g_WorldViewProjectionMatrix;
			vec4 zExtra = vec4(0,0,0,0);
			zExtra.yz =  (1.0 + zPC.xy / zPC.w ) / 2.0;
			zExtra.z = (1.0 - zExtra.z);
			zExtra.yz += vec2(du/2,dv/2);
			zExtra.w=1.0/zPC.w;//In.Color2.x;
		
			float VSWde = pow((1.0/lerp(oExtra.w, 1.0, WFogLerpPosRand))*(WFogDensity/10000.0,2.0),WFogPower);
			float VSWdeDelta = saturate(WOldFogWde-VSWde);
				
			vec4 SPos4VS = vec4(lerp(oWorldPos.xyz, g_LocalViewPos.xyz, WFogLerpPosRand),1.0);
			SPos4VS = SPos4VS * ShadowTM;
			SPos4VS.xy += vec2(0.5/ShadowMapSide,0.5/ShadowMapSide);
			SPos4VS.y = 1.0 - SPos4VS.y;

			vec3 dVS = vec3(1.0,1.0/255.0,1.0/255.0/255.0);

			vec3 VSPos = SPos4VS.xyz;
			vec3 mVS = texture(ShadowSampler,VSPos.xy).xyz;	
				
			float MultiplierVS = saturate(2.0-(VSPos.z-dot(mVS,dVS)-fshadowBias)*WShadowMapSize*2.0);
			WFogVolumeColorResult += WFogColor.zyx*lightColor.xyz*MultiplierVS*VSWdeDelta;
			WOldFogWde = VSWde;
			VSWdeDeltaSum += VSWdeDelta;
			VSWdeDeltaWOShadowSum += VSWdeDelta*MultiplierVS;
		}
		
		float fogMask = saturate(min(Wde, Wde*pow(VSWdeDeltaWOShadowSum/VSWdeDeltaSum, max(0.1,WFogShadows-1.0))));
		vec3 fogLight = WFogVolumeColorResult/VSWdeDeltaSum;
		color.xyz = lerp(color.xyz,lerp(WFogColor.zyx*lightColor.xyz, fogLight, min(1.0, WFogShadows)), fogMask).xyz;
		
		#if D_RRenderPass == RP_FOG_LIGHT
			FragColor = saturate(vec4(fogLight.x/2.0, fogLight.y/2.0, fogLight.z/2.0, 1.0)); 
			return;
		#endif
		#if D_RRenderPass == RP_FOG_MASK
			FragColor = saturate(vec4(fogMask,fogMask,fogMask,1)*2.0); 
			return;
		#endif
		
	#else
		color.xyz = lerp(color.xyz,WFogColor.zyx*lightColor.xyz,Wde).xyz;
	#endif
#endif	
#else
	#ifdef D_WFogDensity
		color.xyz = lerp(color.xyz,WFogColor.zyx*lightColor.xyz,Wde).xyz;
	#endif
#endif	
#else
	#ifdef D_WFogDensity
		color.xyz = lerp(color.xyz,WFogColor.zyx,Wde).xyz;
	#endif
#endif	
#endif	
#endif			
//// RR END ///

	vec3 ResColor = pow(color.xyz,vec3(igamma));
	color.xyz = lerp(ResColor,ResColor*0.5,Freeze*FreezeMod);//+saturate(pow(1.0-dotNV,20.0)*15.0);
	color.w = sfColor.w;

//	color.xyz *= getmodf(color.xyz)*LDiffuse22C;
	color *= SelectionColor;

	color.w = 1.0;
