#define ROTATION
#define oVDir normalize(oRawPos.xyz - g_LocalViewPos)
        if(mod(gl_FragCoord.x+gl_FragCoord.y,2.0)==GridConst)discard;

#define IS_VOXEL_SHADER
		
	float mpl = 1.0;
	float L = length(oN);
#ifdef USE_DEPTH
	vec3 d0 = vec3(1.0,1.0/255.0,1.0/255.0/255.0);
	const float dk=3.8;	
	vec4 c0 = texture(DepthSampler, oExtra.yz-vec2(du*2,0.0));
	vec4 c1 = texture(DepthSampler, oExtra.yz+vec2(du*2,0.0));
	vec4 c2 = texture(DepthSampler, oExtra.yz-vec2(0.0,dv*2));
	vec4 c3 = texture(DepthSampler, oExtra.yz+vec2(0.0,dv*2));
	
	float vv0 = dot(c0.rgb,d0);
  	float vv1 = dot(c1.rgb,d0);
  	float vv2 = dot(c2.rgb,d0);
  	float vv3 = dot(c3.rgb,d0);
	
	float va = vv0+vv1+vv2+vv3;
  	va /= 4.0;
	vec3 NN0=normalize(vec3(vv0-vv1,vv2-vv3,-(depK1+depK2*va*2.0)*du*dk));
	vec3 N = -normalize(NN0 * g_ViewWorldMatrix3);
	
	vec3 Normal = normalize(N);
#else //!USE_DEPTH
#ifdef FLAT_SHADING
	vec3 Normal = normalize(cross(dFdx(oMPos),dFdy(oMPos)))*Inverse;
#else //!FLAT_SHADING
	vec3 Normal = -oN / L;
#endif //FLAT_SHADING
	L=oC2.y+1.0;

#endif //USE_DEPTH

#ifdef PRINTING            
	vec3 NG = normalize((vec4(Normal,0.0)*g_WorldMatrix).xyz);
	float wxy=NG.z*NG.z;
	float wyz=NG.x*NG.x;
	float wzx=NG.y*NG.y;
#else
	float wxy=Normal.z*Normal.z;
	float wyz=Normal.x*Normal.x;
	float wzx=Normal.y*Normal.y;
#endif
        float wz0=wzx;
#ifdef PRINTING
	wzx*=0.05;
	wxy=pow(wxy,8.0);
	wyz=pow(wyz,8.0);
	wzx=pow(wzx,8.0);
#else
	wxy*=wxy;
	wyz*=wyz;
	wzx*=wzx;
#endif
	float sw = wxy+wyz+wzx;
	wxy/=sw;
	wyz/=sw;
	wzx/=sw;
	sw=1.0;
#ifdef PRINTING
	wxy*=wz0+1.0;
	wyz*=wz0+1.0;
#endif
	vec3 dN = vec3(0);

#ifdef ROTATION
	vec2 xy=rotate(oMPos.xy, RotationSide1);
	vec2 yz=rotate(oMPos.yz, RotationSide2);
	vec2 zx=rotate(oMPos.zx, RotationTop);
	vec2 nmod=vec2(1.0-2.0*FlipNormalmapR, 1.0-2.0*FlipNormalmapG);
#else
	vec2 xy=oMPos.xy;
	vec2 yz=oMPos.yz;
	vec2 zx=oMPos.zx;
	vec2 nmod=vec2(1.0,1.0);
#endif

#ifdef USE_NORMALMAP
	vec4 nxy=texture(CustomSampler2,xy);
#ifdef PRINTING
	vec4 nyz=texture(CustomSampler2,yz.yx);
	vec4 nzx=texture(CustomSampler2,(zx-zx.yx)/2.5);
	dN=vec3(nxy.x-0.5,0.5-nxy.y,0.0)*wxy;
	dN-=vec3(0.0,nyz.y-0.5,0.5-nyz.x)*wyz;
	dN+=vec3(0.5-nzx.y,0.0,nzx.x-0.5)*wzx;
	
#else
	vec4 nyz=texture(CustomSampler2,yz);
	vec4 nzx=texture(CustomSampler2,zx);
#ifdef ROTATION
	nxy.xy-=vec2(0.5,0.5);
	nyz.xy-=vec2(0.5,0.5);
	nzx.xy-=vec2(0.5,0.5);
	nxy.xy*=nmod;
	nyz.xy*=nmod;
	nzx.xy*=nmod;

	nxy.xy=rotate(nxy.xy, RotationSide1);
	nyz.xy=rotate(nyz.xy, RotationSide2);
	nzx.xy=rotate(nzx.xy, RotationTop);

	dN=vec3(nxy.x,-nxy.y,0.0)*wxy;
	dN+=vec3(0.0,nyz.x,-nyz.y)*wyz;
	dN+=vec3(-nzx.y,0.0,nzx.x)*wzx;
#else
	dN=vec3(nxy.x-0.5,0.5-nxy.y,0.0)*wxy;
	dN+=vec3(0.0,nyz.x-0.5,0.5-nyz.y)*wyz;
	dN+=vec3(0.5-nzx.y,0.0,nzx.x-0.5)*wzx;
#endif
#endif
	dN*=Bumpness;
#ifdef PRINTING
	float L3=length(dN);
	dN=normalize((vec4(dN,0.0)*g_WorldMatrixInverse).xyz)*L3;
#endif
	vec3 N0=Normal;
	Normal=normalize(Normal+dN);
#endif	      

	vec3 ColorModulator = vec3(1.0);
	float GlossModulator = 1.0;
	float MetallModulator = 1.0;

#ifdef USE_COLORTEX
	vec4 mxy=texture(CustomSampler1,xy);
	vec4 myz=texture(CustomSampler1,yz);
	vec4 mzx=texture(CustomSampler1,zx);
	mxy=(mxy*wxy+myz*wyz+mzx*wzx)/sw;
	ColorModulator = mxy.xyz;
#endif
#ifdef USE_GLOSSTEX
	vec4 gxy=texture(CustomSampler4,xy);
	vec4 gyz=texture(CustomSampler4,yz);
	vec4 gzx=texture(CustomSampler4,zx);
	gxy.y=(gxy.y*wxy+gyz.y*wyz+gzx.y*wzx)/sw;
	GlossModulator = gxy.y;
#endif
#ifdef USE_METALLTEX
	vec4 mmxy=texture(CustomSampler5,xy);
	vec4 mmyz=texture(CustomSampler5,yz);
	vec4 mmzx=texture(CustomSampler5,zx);
	mmxy.y=(mmxy.y*wxy+mmyz.y*wyz+mmzx.y*wzx)/sw;
	MetallModulator = mmxy.y;
#endif

	vec3 GlobalNormal = Normal;
	vec3 ReflectionDir = oVDir - Normal * dot(oVDir, Normal) * 2.0;
	vec3 ViewDir = oVDir;
	ReflectionDir = normalize(ReflectionDir*WPanMatrix);
	//Normal=normalize(N0+dN/12.0);
#ifdef USE_NORMALMAP
	Normal = mix(Normal,N0,SSS_Degree);
#endif
	Normal = normalize(Normal*WPanMatrix);
	ViewDir = -normalize(ViewDir*WPanMatrix);	
	
	vec4 sfColor = oC;
	vec4 sfSpecular = oC2;
	float Emissive = oC2.x;
#ifdef USE_CAVITY
	vec3 dxx=dFdx(oN);
	vec3 dyy=dFdy(oN);//*IncSign;
	float dpv = saturate(dot(Normal,ViewDir));
	float ca0 = (CavityCo.x*(1.0/(vec4(oRawPos,1.0) * g_WorldViewProjectionMatrix).w)+CavityCo.y)*(dot(dxx,LocalRightDir)+dot(dyy,LocalUpDir))*sqrt(dpv);

	float cavity = saturate(ca0*cavityIntensity*1.25 - 0.25);
	vec3 cmod = mix(Color.xyz,cavityColor.xyz,cavity);
	float gmod = mix(ExtraGloss,cavityGloss,cavity);
	float mmod = mix(Metalness,cavityMetall,cavity);

	cavity = saturate(-ca0*bulgeIntensity*1.25 + 0.25);
	cmod = mix(cmod,bulgeColor.xyz,cavity);
	gmod = mix(gmod,bulgeGloss,cavity);
	mmod = mix(mmod,bulgeMetall,cavity);
	
	ColorModulator *= cmod;
	GlossModulator *= gmod;
	MetallModulator *= mmod;
#else
	ColorModulator *= Color.xyz;
	GlossModulator *= ExtraGloss;
	MetallModulator *= Metalness;
#endif
	L=1.0+oC2.y;
#ifdef BAS_RELIEF
	vec4 nrm=vec4(GlobalNormal,0.0);
	float dp=dot(normalize((g_WorldMatrixInverse*nrm).xyz),BasReliefDir);
	//float dp=dot(GlobalNormal,BasReliefDir);
#ifdef UNDERCUTS
	float dpc = saturate(dp*30+0.5);
	vec3 idn = lerp(vec3(1.0/UndercutsTopBottomValue,UndercutsTopBottomValue,UndercutsTopBottomValue), vec3(UndercutsTopBottomValue,UndercutsTopBottomValue,1.0/UndercutsTopBottomValue), dpc);
	float tap = sin(TaperingAngle*0.0174533);
	vec3 c1 = lerp(idn, vec3(1.0/UndercutsEdgeValue,UndercutsEdgeValue,UndercutsEdgeValue),saturate((dp+tap)*60.0*BEdgeWidth-1.5));
	vec3 c2 = lerp(idn, vec3(UndercutsEdgeValue,UndercutsEdgeValue,1.0/UndercutsEdgeValue),saturate((tap-dp)*60.0*BEdgeWidth-1.5));
	ColorModulator *= lerp(c1,c2,saturate(dp*50.0+0.5));
#else
	ColorModulator *= lerp(vec3(1.0,1.0,1.0), vec3(1.0/UndercutsTopBottomValue,UndercutsTopBottomValue,UndercutsTopBottomValue),saturate((sin(TaperingAngle*0.0174533)-dp)*80.0-1.5));
#endif	
#endif //BAS_RELIEF
