#line 0 100
uniform float WFogDensity;
uniform float WFogShadows;
uniform float WFogPower;
uniform vec4 WFogColor;
uniform float WVolumeFogSamples;
uniform float WLightSilhouette;
uniform float WSilhouette;
uniform float WShadowMapSize;
uniform float WFogRand;
uniform mat4 ShadowTM;
uniform float ShadowStep;
uniform float ShadowMapSide;

uniform vec3 g_LocalViewPos;
//uniform mat4 g_WorldViewProjectionMatrix;
uniform float NGScale;
uniform float RRenderPass;
uniform float du;
uniform float dv;
uniform float vpWidth;
uniform float vpHeight;

uniform sampler2D tBRDF;
uniform sampler2D PanoramaDiffuse;
uniform float Metalness;
uniform float ExtraGloss;
uniform float BasePlasticReflection;
uniform float MaxPlasticReflection;
uniform float PaintOpacity;
uniform float LightContrast;
uniform float IsExternalLight;
uniform float LightScatter;
uniform vec3 ExtraGamma;
uniform vec4 LightColor2g;
uniform vec4 SSScolor;
uniform float Translucence;
uniform float FreezeMod;
uniform float Inverse;
#define GlobalViewDir (-oVDir)

#ifdef BAS_RELIEF
uniform vec3 BasReliefDir;
uniform vec3 BasReliefBase;
uniform float TaperingAngle;
uniform float UndercutsEdgeValue;
uniform float UndercutsTopBottomValue;
uniform float BEdgeWidth;
#endif

uniform mat4 g_WorldMatrix;
uniform mat4 g_WorldMatrixInverse;
uniform vec4 SelectionColor;

uniform mat4 MaterialTransform;

uniform float ProjectorOpacity;
uniform mat4 ProjectorTM;
uniform sampler2D ProjectorSampler;
uniform sampler2D AScreenSampler;
uniform sampler2D DepthSampler;


uniform float CurrentIteration;
uniform float SecondLightIntensity;


uniform float OverallScale;
uniform float LayerThickness;

uniform vec3 MousePos;
uniform float TimeSeconds;

uniform float FlipNormalmapR;
uniform float FlipNormalmapG;
uniform float RotationTop;
uniform float RotationSide1;
uniform float RotationSide2;

uniform float UseACES;

in vec3 oWorldPos;
in vec3 oRawPos;
in vec3 oRawNormal;

float defMetall = 0;
vec3 defAlbedo = vec3(0,0,0);

vec4 ScreenSpaceRayTrace(vec3 aFromPoint, vec3 aDirection, float aScatter, float aIterations, float aMinStepSize, float aAccuracy, float aRough){

	vec4 iHitResult = vec4(0.0, 0.0, 0.0, 0.0);
	bool iSSRayHit = false;
#ifdef SHADOWS
	if(CurrentIteration > 2){
		vec3 dotRawDepth = vec3(1.0,1.0/255.0,1.0/255.0/255.0);

		vec4 pxSSPos4 = vec4(aFromPoint, 1.0) * g_WorldViewProjectionMatrix; 
		vec2 pxSSUV = pxSSPos4.xy/pxSSPos4.w*0.5+vec2(0.5, 0.5); 

		vec4 finResultColor = texture(AScreenSampler, pxSSUV);
		vec4 depthRaw = texture(DepthSampler, pxSSUV);
		float pxDepth = dot(dotRawDepth, depthRaw.xyz)*65536.0;
		float pxDepthScale = pxSSPos4.z/pxDepth;

		vec3 iDirection = mix(aDirection, -oVDir.xyz, 0.3+aRough*aRough*0.7);
		vec4 v4Random = fract(abs(cos(vec4(CurrentIteration*61334.0, CurrentIteration*23244.0, CurrentIteration*35809.0, CurrentIteration*5242.0)+pxSSPos4.xyzy*1335.0+aDirection.yzxz*15140.0+aFromPoint.yzxz*5360.0)*(aScatter+1.0))*112.0)*2.0-vec4(1.0,1.0,1.0,1.0);
		vec3 inStep = normalize((aDirection)+v4Random.xyz*0.95*aScatter*mix(v4Random.w, 1.0, 0.35+(aScatter*aScatter+aScatter)*0.5*0.65));
		
		vec4 ssrPxPos4 = vec4(aFromPoint+inStep, 1.0) * g_WorldViewProjectionMatrix; 
		vec2 ssrPxUV = abs(pxSSUV-(ssrPxPos4.xy/ssrPxPos4.w*0.5+vec2(0.5, 0.5))); 
		float stepSize = 1.0/max(ssrPxUV.x*vpWidth, ssrPxUV.y*vpHeight);
		inStep *= stepSize*aMinStepSize;
		
		ssrPxPos4 = pxSSPos4;
		
		vec4 inStepExpo = vec4(inStep, length(inStep));
	
		vec2 ssrPxUVHit = ssrPxUV;
		float ssrPxDepth = pxDepth;
		float ssrPxDepthPrev = ssrPxDepth;
		vec4 ssrPxPos4Prev = ssrPxPos4;
		float lRandom = (1.0+v4Random.w*aAccuracy);
		for(float i = 1; i < aIterations; i++){
			ssrPxDepthPrev = ssrPxDepth;
			ssrPxPos4Prev = ssrPxPos4;
		
			ssrPxPos4 = vec4(aFromPoint+inStepExpo.xyz*lRandom, 1.0) * g_WorldViewProjectionMatrix; 
			ssrPxUV = ssrPxPos4.xy/ssrPxPos4.w*0.5+vec2(0.5, 0.5); 

			vec4 ssrDepthRaw = texture(DepthSampler, ssrPxUV);
			ssrPxDepth = dot(dotRawDepth, ssrDepthRaw.xyz)*65536.0;
			
	
			if(ssrPxDepth*pxDepthScale <= ssrPxPos4.z && (ssrPxPos4.z / pxSSPos4.z < ssrPxDepth / pxDepth * 1.2)){
				iSSRayHit = true;
				break;
			}
			inStepExpo = inStepExpo*(1.0+aAccuracy);
		}
		
		vec2 miZeroPos = ssrPxUV;
		
		float angleE = ((ssrPxDepth-pxDepth)*pxDepthScale) / (ssrPxPos4.z-pxSSPos4.z);
		bool isGoodAngle = (angleE > 0.80-aAccuracy*0.15);

		// get intersection point
		bool noDepthStep = abs(normalize(ssrPxPos4Prev.xyz-ssrPxPos4.xyz).z) < 0.5;
		float pxD1 = ssrPxDepthPrev*pxDepthScale-ssrPxPos4Prev.z;
		float pxD2 = ssrPxDepth*pxDepthScale-ssrPxPos4.z;
		float pxDE = pxD2/(pxD2-pxD1);
		vec4 ssrPxPos4Hit = mix(ssrPxPos4Prev, ssrPxPos4, 1.0-pxDE);

		vec2 ssrPxUV2 = ssrPxPos4Hit.xy/ssrPxPos4Hit.w*0.5+vec2(0.5, 0.5); 
		vec4 ssrDepthRaw = texture(DepthSampler, ssrPxUV2);
		ssrPxDepth = dot(dotRawDepth, ssrDepthRaw.xyz)*65536.0;		

		float angleE2 = ((ssrPxDepth-pxDepth)*pxDepthScale) / (ssrPxPos4Hit.z-pxSSPos4.z);
		float ssrHitDepth = ssrPxDepth*pxDepthScale;
		bool isGoodAngle2 = (angleE2 > 0.80-aAccuracy*0.15) && (ssrHitDepth <= ssrPxPos4.z || ssrHitDepth <= ssrPxPos4Prev.z);
		if(isGoodAngle2 || noDepthStep) ssrPxUV = ssrPxUV2;
		
		if(iSSRayHit && (isGoodAngle || isGoodAngle2 || noDepthStep) && !(ssrPxUV.x < 0.0 || ssrPxUV.x > 1.0 || ssrPxUV.y < 0.0 || ssrPxUV.y > 1.0)){
			vec3 hitPoint = aFromPoint+inStepExpo.xyz*lRandom;
			
			vec4 ssrPxPosMip1 = vec4(hitPoint.x-inStepExpo.w, hitPoint.y, hitPoint.z, 1.0) * g_WorldViewProjectionMatrix;
			vec4 ssrPxPosMip2 = vec4(hitPoint.x, hitPoint.y-inStepExpo.w, hitPoint.z, 1.0) * g_WorldViewProjectionMatrix;
			vec4 ssrPxPosMip3 = vec4(hitPoint.x, hitPoint.y, hitPoint.z-inStepExpo.w, 1.0) * g_WorldViewProjectionMatrix;
			
			vec2 ssrPxPosMipSize = max(max(
											abs((ssrPxPosMip1/ssrPxPosMip1.w*0.5).xy+vec2(0.5, 0.5)-miZeroPos), 
											abs((ssrPxPosMip2/ssrPxPosMip2.w*0.5).xy+vec2(0.5, 0.5)-miZeroPos)), 
											abs((ssrPxPosMip3/ssrPxPosMip3.w*0.5).xy+vec2(0.5, 0.5)-miZeroPos)) * 0.03125 * aScatter;

			float mipSize = max(ssrPxPosMipSize.x, ssrPxPosMipSize.y);
				
			float iMipY = ssrPxUV.y-mipSize*2.0;
			float pxMulF = 1.0/CurrentIteration;
			for(int iy = 0; iy < 5; iy++) {	
				float iMipX = ssrPxUV.x-mipSize*2.0;
				for(int ix = 0; ix < 5; ix++) {	
					vec4 mipSample = texture(AScreenSampler, saturate(vec2(iMipX, 1.0-iMipY)))*pxMulF;
					float iAlpha = saturate(mipSample.w);
					iHitResult.xyz += max(vec3(0.0,0.0,0.0),mipSample.xyz*iAlpha);
					iHitResult.w += iAlpha;
					iMipX += mipSize;
				}
				iMipY += mipSize;
			}
			iHitResult.xyz *= 0.5+(1.0-saturate(aScatter))*0.5;
			
			iHitResult = saturate(iHitResult*0.01)*4.0;//texture(AScreenSampler, vec2(ssrPxUV.x, 1.0-ssrPxUV.y))/CurrentIteration;
//			iHitResult = texture(AScreenSampler, vec2(ssrPxUV.x, 1.0-ssrPxUV.y))/CurrentIteration;
		}

	} else iHitResult.w = 1.0;
//	iHitResult.xyz = pow(iHitResult.xyz, vec3(2.2, 2.2, 2.2));
	
#endif 
	return iHitResult;



//
}
vec2 rotate(vec2 xy, float angle){
	float _co=cos(angle);
	float _si=sin(angle);
	return vec2(xy.x*_co - xy.y*_si, xy.x*_si + xy.y*_co); 
}
