const float PI = 3.14159265;
const float PI2 = 6.28318530;
const float PIDiv180 = 0.01745329;
const float _180DivPI = 57.29577951;


float rgbAverage(vec3 aRgb)
{
	return (aRgb.r+aRgb.g+aRgb.b)/3.0;
}


vec2 Rotate(float aAngle, vec2 aSrc)
{
  float iAngle = aAngle * PIDiv180;
  float iSin = sin(iAngle);
  float iCos = cos(iAngle);
  return vec2((aSrc.x * iCos) - (aSrc.y * iSin), (aSrc.y * iCos) + (aSrc.x * iSin));
}

float randomNoise(vec2 aUV, float aSeed) {

	return 0.01+(fract(sin(dot(aUV.xy ,vec2(aSeed+54.9898,aSeed*6.233+6.233))) * 83875.323+aSeed))*0.98;

}

