// Vertex shader

uniform mat4 g_WorldMatrix;
uniform mat4 g_ScreenMatrixInverse;

in vec3 Pos;

out vec2 v_SrcPos;

void main() {
	v_SrcPos = vec2(Pos);
	gl_Position = vec4(Pos, 1.0) * g_WorldMatrix * g_ScreenMatrixInverse;
}

// Fragment shader

uniform vec2 c_SegFrom;
uniform vec2 c_SegTo;
uniform vec4 c_CenterColor;
uniform vec4 c_BoundColor;
uniform float c_SegRadius;
uniform float c_GradRadius;
uniform float c_Power;
uniform float c_CaveFrom;
uniform float c_CaveTo;
uniform float c_FlatFrom;
uniform float c_FlatTo;
uniform vec2 c_HalfFrom;
uniform vec2 c_HalfTo;
uniform float c_HalfFlat;

in vec2 v_SrcPos;

out vec4 FragColor;
void main() {
#ifdef HORIZONTAL
	vec2 Proj = vec2(v_SrcPos.x, c_SegFrom.y);
	vec2 ClosestPoint = vec2(clamp(Proj.x, c_SegFrom.x, c_SegTo.x), Proj.y);

#else // VERTICAL
	vec2 Proj = vec2(c_SegFrom.x, v_SrcPos.y);
	vec2 ClosestPoint = vec2(Proj.x, clamp(Proj.y, c_SegFrom.y, c_SegTo.y));
#endif // HORIZONTAL
	float R = distance(v_SrcPos, ClosestPoint);
	
	float l;
	
	l = (2.0 * c_SegRadius - distance(c_SegFrom, v_SrcPos)) * c_CaveFrom;
	R = max(R, l);

	l = (2.0 * c_SegRadius - distance(c_SegTo, v_SrcPos)) * c_CaveTo;
	R = max(R, l);
	
	l = (c_SegRadius - distance(c_SegFrom, Proj)) * c_FlatFrom;
	R = max(R, l);

	l = (c_SegRadius - distance(c_SegTo, Proj)) * c_FlatTo;
	R = max(R, l);

#ifdef HORIZONTAL
	vec2 HalfProj = vec2(v_SrcPos.x, c_HalfFrom.y);
#else // VERTICAL
	vec2 HalfProj = vec2(c_HalfFrom.x, v_SrcPos.y);
#endif // HORIZONTAL
	l = distance(v_SrcPos, HalfProj) * c_HalfFlat;
	R = max(R, l);
	
	float Delta = c_SegRadius - c_GradRadius;
	R -= Delta;
	if(R < 0.0) {
		R = 0.0;
	}
	if(R > c_GradRadius) {
		discard;
	}
	float k = pow(R / c_GradRadius, c_Power);
	vec4 c = lerp(c_CenterColor, c_BoundColor, k);

	FragColor = c;
}