
// Vertex shader

in vec3 Pos;
in vec2 TexCoord;

out vec4 oPos;
out vec2 oTexCoord;

void main() {
	oTexCoord.x = TexCoord.x;
	oTexCoord.y = TexCoord.y;
	oPos.x = Pos.x;
	oPos.y = Pos.y;
	oPos.z = Pos.z;
	oPos.w = 1.0;

	gl_Position = oPos;
	
}


// Fragment shader

in vec4 oPos;
uniform vec3 ViewPos;
in vec2 oTexCoord;

out vec4 FragColor;
uniform sampler2D Panorama;

uniform float aSceneTime;

void main() {


	vec4 SrcColor = texture(Panorama, vec2(oTexCoord.x, 1.0-oTexCoord.y));	
	
	SrcColor.xyz *= 5.0-SrcColor.w*4.0;

#ifdef NODE_CODE
	#define ioPanorama Panorama;
	ioCameraPosition = vec4(ViewPos, 0.0);
	float uMod = abs(sin(oTexCoord.y*3.14159));
	ioRayDir = -normalize(vec4(cos((oTexCoord.x+0.48)*6.28319)*uMod,/*oTexCoord.y*2.0-1.0*/1.0-(cos(oTexCoord.y*3.14159)*0.5+1.0)/*asin(1.0-oTexCoord.y*2.0)*0.318310*/, sin((oTexCoord.x+0.48)*6.28319)*uMod, 0.0));

	////////////////////////////////////////////////
	ioResolution = vec4(4096.0, 2048.0, 0.0, 0.0);           // viewport resolution (in pixels)
	ioTime = vec4(aSceneTime);                 // shader playback time (in seconds)
	ioTimeDelta = 0.033*vec4One;            // render time (in seconds)
	ioFrame = vec4Zero;                // shader playback frame
	ioMouse = vec4Zero;                // mouse pixel coords. xy: current (if MLB down), zw: click
	ioFragCoord = oTexCoord.xyxy;
	ioPosition = oTexCoord.xyxy;
	ioNormal = vec4(0.0, 1.0, 0.0, 0.0);

	ioPM = vec4(SrcColor.xyz*0.5, 1.0);
	ioPQ1 = vec4(0.5);
	ioPQ2 = vec4(0.0);
	ioPQ3 = vec4(0.5);
	ioPQ4 = vec4(0.5);
	ioPN = vec4(0.5, 0.5, 0.0, 0);
	
	ioDisplacement = vec4Zero;

	NODE_CODE;


	SrcColor.xyz = ioPM.xyz*2.0;
#endif
	float MaxCnl = max(max(SrcColor.x, SrcColor.y),SrcColor.z);
	float MaxDiv = max(MaxCnl,1.0);
	SrcColor.xyz /= MaxDiv;
	
	
	FragColor = vec4(SrcColor.xyz,1.0-saturate((MaxDiv-1.0)*0.25));
}


