// Vertex shader

uniform mat4 Transform;
uniform float ZShift;

in vec3 Pos;
in vec3 Normal;
in vec4 Color;
out vec3 v_Normal;

void main() {
	vec4 P = vec4(Pos, 1.0);
	P *= Transform;
	P.y *= -1.0;
	P.z = 1.0 - (P.z + ZShift)*0.01;
	gl_Position = P;
	P = vec4(Normal, 0.0);
	vec4 N = P * Transform;	
	v_Normal=normalize(N.xyz);
}

// Fragment shader

in vec3 v_Normal;
uniform vec3   LDir; 
out vec4 FragColor;

void main() {
	vec3 N=normalize(v_Normal);
	float   D = (0.6+dot(N,normalize(LDir)));	
	vec4 C1 = vec4(D,D,D,1.0);
	FragColor = C1;
}