// Vertex shader

uniform mat4 g_WorldMatrix;
uniform mat4 g_ScreenMatrixInverse;

in vec3 Pos;
in vec2 TexCoord;

out vec2 v_TexCoord;

void main() {
	gl_Position = vec4(Pos, 1.0) * g_WorldMatrix * g_ScreenMatrixInverse;
	v_TexCoord = TexCoord;
}

// Fragment shader

uniform sampler2D s_Decal;
uniform float c_Disabled;
uniform float c_Hot;
uniform float c_Alpha;

in vec2 v_TexCoord;

// ToGray
float ToGray(in vec4 Color) {
	return Color.r * 0.2125 + Color.g * 0.7154 + Color.b * 0.0721;
}

// Sepia
vec4 Sepia(in vec4 Color) {
	vec4 Lo = vec4(0.34509805, 0.33725491, 0.32549021, Color.a);
	vec4 Hi = vec4(0.92941183, 0.92549026, 0.90980399, Color.a);
	return lerp(Lo, Hi, ToGray(Color));
}

// GammaCorrection
vec4 GammaCorrection(in vec4 Color, in float l) {
	float r = pow(Color.r, 1.0 / l);
	float g = pow(Color.g, 1.0 / l);
	float b = pow(Color.b, 1.0 / l);
	return vec4(r, g, b, Color.a);
}

out vec4 FragColor;
void main() {
	vec4 S = texture(s_Decal, v_TexCoord);
	vec4 c = (1.0 - c_Disabled) * (1.0 - c_Hot) * S;
	c += c_Disabled * Sepia(S);
	c += c_Hot * GammaCorrection(S, 0.75);
	c.a *= c_Alpha;
	FragColor = c;
}