// Vertex shader

uniform mat4 g_WorldMatrix;
uniform mat4 g_ScreenMatrixInverse;

in vec3 Pos;
in vec4 Color;
in vec2 TexCoord;

out vec4 v_Color;
out vec2 v_TexCoord;

void main() {
	gl_Position = vec4(Pos, 1.0) * g_WorldMatrix * g_ScreenMatrixInverse;
	v_Color = Color;
	v_TexCoord = TexCoord;
}

// Fragment shader

uniform sampler2D s_Glyphs;

in vec4 v_Color;
in vec2 v_TexCoord;

out vec4 FragColor;
void main() {
	vec4 Color = v_Color;
	Color.a *= texture(s_Glyphs, v_TexCoord).r;
	FragColor = Color;
}