// Vertex shader

in vec3 Pos;
in vec3 Normal;
in vec2 TexCoord;
in vec3 Tangent;
in vec3 BiTangent;
in vec4 Indices;
in vec4 Weights;

out vec3 oPos;
out vec3 oNormal;
out vec2 oTexCoord;
out vec3 oTangent;
out vec3 oBiTangent;
out vec4 oIndices;
out vec4 oWeights;


void main() {

	vec4 P = vec4(TexCoord.x*2.0-1.0, (TexCoord.y*2.0-1.0), 0.5, 1.0);
	oPos = Pos;
	oNormal = Normal;
	oTexCoord = TexCoord;
	oTangent = Tangent;
	oBiTangent = BiTangent;
	oIndices = Indices;
	oWeights = Weights;
		gl_Position = P;

}

// Pixel shader
#line 35
in vec3 oPos;
in vec3 oNormal;
in vec2 oTexCoord;
in vec3 oTangent;
in vec3 oBiTangent;
in vec4 oIndices;
in vec4 oWeights;
   

out vec4 FragData[8];
void main() {
//	    FragColor = vec4(1.0, 0.5, 0.0, 1.0);

#ifdef NODE_CODE
	
	ioTime = vec4Zero;                 // shader playback time (in seconds)
	ioMouse = vec4Zero;                // mouse pixel coords. xy: current (if MLB down), zw: click
	ioFragCoord = vec4(oTexCoord,oTexCoord);
	ioUV = ioFragCoord;
	ioPosition = vec4(oTexCoord, oTexCoord);
	ioNormal = vec4(oTexCoord, oTexCoord);

	ioPM = vec4Zero;
	ioPQ1 = vec4Zero;
	ioPQ2 = vec4Zero;
	ioPQ3 = vec4Zero;
	ioPQ4 = vec4Zero;
	ioPN = vec4Zero;
	ioDisplacement = 0.0;

	ioLightDir = vec4(0.0);
	ioCameraPosition = vec4Zero;
	ioIteration = vec4One;

	NODE_CODE;

	FragData[0] = OutData[0];
	FragData[1] = OutData[1];
	FragData[2] = OutData[2];
	FragData[3] = OutData[3];
	FragData[4] = OutData[4];
	FragData[5] = OutData[5];
	FragData[6] = OutData[6];
	FragData[7] = OutData[7];

#endif

}
