// Vertex shader

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_TextureMatrix0;

attribute vec4 Color;

varying vec4 v_Color;
varying vec2 v_TexCoord;

void main() {
	vec3 Pos = vec3(gl_Vertex);
	vec2 TexCoord = vec2(gl_MultiTexCoord0);

	gl_Position = vec4(Pos, 1.0) * g_WorldViewProjectionMatrix;
	v_Color = Color;
	v_TexCoord = vec2(vec4(TexCoord, 0.0, 1.0) * g_TextureMatrix0);
}

// Fragment shader

uniform sampler2D s_Sampler;

varying vec4 v_Color;
varying vec2 v_TexCoord;

void main() {
	vec4 c = texture2D(s_Sampler, v_TexCoord);
	c *= v_Color;
	
	gl_FragColor = c;
}