import coat
from cTemplates.Structs import *


@d_template
def NavigationBar():
    NavigationBar.IncludeContent()
    ViewPortMenu()

@d_child(NavigationBar)
def Light():
    coat.menu_item("@LIGHT_CONTRAST") # /Adjust the contrast of lighting. It is better to increase contrast for comfortable sculpting....
    coat.menu_item("@LIGHT_BRIGHTNESS") # /Adjust the primary light intensity by holding the LMB down over this control and moving the mouse
    coat.menu_item("@MOVE_LIGHT") # /Adjust the light angle by holding the LMB down over this control and moving the mouse
    coat.menu_item("@BLUR_PANO") # /Drag to blur/sharp the environment texture in the viewport background
@d_child(NavigationBar)
def Roll():
    coat.menu_item("$NAVY_ROLL_LEFT")
    coat.menu_item("$NAVY_ROLL_RIGHT")

@d_child(NavigationBar)
def Camera():
    coat.menu_item("@TOGGLE_Y_ROTATION") # /Toggle between two rotation modes - rotation around vertical axis or free rotation.
    coat.menu_item("$NAVY_RORATE") # /Rotate the camera by holding the LMB down over this control and moving the mouse. To rotate the camera without this control use ALT+LMB (Material navigation should be Enabled in Prefereces->Viewport). Click RMB over the button to reset rotation.
    coat.menu_item("$NAVY_MOVE") # /Move the camera by holding the LMB down over this control and moving the mouse. To move the camera without this control use ALT+MMB or the mouse wheel (Material navigation should be Enabled in Prefereces->Viewport). Click RMB over the button to reset position.
    coat.menu_item("$NAVY_SCALE") # /Zoom the camera by holding the LMB down over this control and moving the mouse. To zoom the camera without this control use ALT+RMB (Material navigation should be Enabled in Prefereces->Viewport). Click RMB over the button to reset scale.
    coat.menu_item("@NAVY_FOV") # /Vary field of view (FOV). Press RMB to reset it to default

@d_child(NavigationBar)
def ViewPort():
    coat.menu_item("$NAVIFRAME") # /Frame. Put scene or current object (in Sculpt room) in the center of viewport and scale it to fit
    coat.menu_item("$NAVY_FRAME2") # /Focus on brush - focus camera on the surface under the brush. Distance to the surface will be determined by the brush radius
    coat.menu_item("@NAVY_CENTER") # /Reset the camera to the default position
    coat.menu_item("$VIEW_ORTHO") # /Toggle between perspective and orthographic projection

@d_child(NavigationBar)
def Grid():
    coat.menu_item("$SHOW_GRID_3D") # /Toggle 3D grid
    coat.menu_item("$SNAP_GRID_3D")

@d_child(NavigationBar)
def View():
    coat.menu_item("$SNAP_NEAREST_VIEW")
    coat.menu_item("$SHOW_AXIS") # /Show/Hide Axis
    coat.menu_item("@ToggleFullscreen") # /Toggle fullscreen mode
    coat.menu_item("@NAVI_PanoramasList") # /Environment Map
    coat.menu_item("@NAVI_Reference") # /Show/Hide Reference Images
    coat.menu_item("@NAVI_Projector") # /You may project any texture through the whole scene similar to projector. This is just for the reference, it does not influence any color or material properties.


@d_child(NavigationBar)
def Addons():
    if coat.iconic_submenu("arrow_drop_down_circle", 32):
        Addons.IncludeContent()
        coat.menu_exit()

@d_child(Addons)
def AddonList():
        coat.menu_item("ListAddons::ROOM::Custom")
        coat.menu_item("NewAddonsSection::Custom1")

################################
##### ViewPortMenu #############

@d_template
def ViewPortMenu():
    if coat.iconic_submenu("Camera4", 32):
        ViewPortMenu.IncludeContent()
        coat.menu_exit()

@d_submenu("Custom_sceme", ViewPortMenu)
def Custom_sceme():
            coat.menu_item("NavigationPresets")
    
@d_menu_section(ViewPortMenu)
def S_edit_navi():
        coat.menu_item("edit_navi") # /Customize Navigation
@d_menu_section(ViewPortMenu)
def S_CameraUndo():
        coat.menu_item("CameraUndo")
        coat.menu_hotkey("Z", 0, 0, 1) # /ALT-Z
        coat.menu_item("CameraRedo")
        coat.menu_hotkey("Y", 0, 0, 1) # /ALT-Y

Background = Submenu("Background", ViewPortMenu)
            
@d_menu_section(Background)
def S_BackgroundType():
            coat.menu_item("GradientBackground") # /Vertical Gradient
            coat.menu_item("ImageBackground") # /Use Background Image
            coat.menu_item("PanoramaBackground") # /Use Environment Map
@d_menu_section(Background)
def S_ChooseBackground():
            coat.menu_item("ChooseTopColor") # /Choose Top Color
            coat.menu_item("ChooseBottomColor") # /Choose Bottom Color
            coat.menu_item("ChooseBackgrImage") # /Choose Background Image
@d_menu_section(Background)
def S_Panorama():
            coat.menu_item("LockPanorama") # /Lock Environment
            coat.menu_item("ChoosePanoramaImage") # /Choose Environment Map
            coat.menu_item("RotatePanoramaCCW") # /Rotate Environment Map CCW
            coat.menu_item("RotatePanoramaCW") # /Rotate Environment Map CW
            coat.menu_item("BlurPanorama") # /Blur Environment Map
            coat.menu_hotkey("[", 1, 0, 0) # /SHIFT+[
            coat.menu_item("SharpenPanorama") # /Sharpen Environment Map
            coat.menu_hotkey("]", 1, 0, 0) # /SHIFT+]
@d_menu_section(Background)
def S_RefImage():
            coat.menu_item("ChooseXRefImage") # /Ref image for X-axis
            coat.menu_item("ChooseYRefImage") # /Ref image for Y-axis
            coat.menu_item("ChooseZRefImage") # /Ref image for Z-axis
            coat.menu_item("EditRefImagesPlacement") # /Edit image placement
            coat.menu_item("PaintOverRefImages") # /Paint over the references
            coat.menu_item("ShowInExactPositions") # /Show in exact views


CameraSnapping = Submenu("CameraSnapping", ViewPortMenu)

@d_menu_section(CameraSnapping)
def S_CameraSnapping():
            coat.menu_item("CameraIsometricSnap45dg") # /Snap camera by 45 degree
            coat.menu_item("CameraIsometricSnapHexagon") # /Equilateral hexagon isometry
            coat.menu_item("CameraIsometricSnapRhombus2x1") # /Rhombus 2x1 isometry
            coat.menu_item("CameraInWorldCenter") # /CameraInWorldCenter
            coat.menu_item("CameraFor2DPaint") # /CameraFor2DPaint
            # menu_item("CameraLock2DCanvas");/CameraLock2DCanvas
    
@d_menu_section(ViewPortMenu)
def S_ViewSide():
        coat.menu_item("VIEW_FRONT") # /Front
        coat.menu_hotkey("NUM2", 0, 0, 0) # /NUM2
        coat.menu_item("VIEW_BACK") # /Back
        coat.menu_hotkey("NUM8", 0, 0, 0) # /NUM8
        coat.menu_item("VIEW_LEFT") # /Left
        coat.menu_hotkey("NUM4", 0, 0, 0) # /NUM4
        coat.menu_item("VIEW_RIGHT") # /Right
        coat.menu_hotkey("NUM6", 0, 0, 0) # /NUM6
        coat.menu_item("VIEW_TOP") # /Top
        coat.menu_hotkey("NUM7", 0, 0, 0) # /NUM7
        coat.menu_item("VIEW_BOTTOM") # /Bottom
        coat.menu_hotkey("NUM1", 0, 0, 0) # /NUM1
        coat.menu_item("ViewAlongNormal") # /Look along normal
        coat.menu_hotkey("NUM*", 0, 0, 0) # /NUM*
@d_menu_section(ViewPortMenu)
def S_Presets():
        coat.menu_item("ADD_CAM_PRESET") # /Add Camera Shortcut
        coat.menu_hotkey("UP", 0, 1, 0) # /CTRL+UP
        coat.menu_item("DEL_CAM_PRESET") # /Delete Camera Shortcut
        coat.menu_hotkey("DOWN", 0, 1, 0) # /CTRL+DOWN
        coat.menu_item("PREV_CAM_PRESET") # /Switch to Previous Shortcut
        coat.menu_hotkey("LEFT", 0, 1, 0) # /CTRL+LEFT
        coat.menu_item("NEXT_CAM_PRESET") # /Switch to Next Shortcut
        coat.menu_hotkey("RIGHT", 0, 1, 0) # /CTRL+RIGHT
        coat.menu_item("SaveCamera") # /Save camera
        coat.menu_item("LoadCamera") # /Load camera
@d_menu_section(ViewPortMenu)
def S_Pivot():
        coat.menu_item("Use3DConnexionPivot")
        coat.menu_item("rotate_around_curr_pick_point") # /Rotate Around Current Pick Point
        coat.menu_item("rotate_around_world_center") # /Rotate Around World Center
        coat.menu_item("rotate_around_last_draw_point") # /Rotate Around Last Draw Point
        coat.menu_item("rotate_around_bound_box_center") # /Rotate Around Object Bounding Box
        coat.menu_item("rotate_around_custom_point") # /Rotate Around Custom Point
        coat.menu_hotkey("F", 0, 0, 0) # /F
        coat.menu_item("rotate_around_camera_origin")
