import coat
from cTemplates.Structs import *

@d_rmb_menu
def CurvesRMB():
    global prim, Closed
    prim = coat.menu_property("IsCurvePrimitive")
    Closed = coat.menu_property("IsCurveClosed")

@d_menu_section(CurvesRMB)
def S_Edit():
    global prim, Closed
    if prim:
        coat.menu_item("ConvertToRegularCurve")
        coat.menu_item("EditPrimParams")

    coat.menu_item("ApplyCurves")
    coat.menu_item("SaveCurve")
    if not prim:
        coat.menu_item("SM_PointsExtrude")

    coat.menu_item("DuplicateCurve")

@d_submenu("PutOnPlane", CurvesRMB)
def PutOnPlane():
        coat.menu_item("AveragePlane")
        coat.menu_item("CmPlaneYZ")
        coat.menu_item("CmPlaneZX")
        coat.menu_item("CmPlaneXY")
        coat.menu_item("PlaneYZ")
        coat.menu_item("PlaneZX")
        coat.menu_item("PlaneXY")

@d_child(CurvesRMB)
def SM_CurvesOperations_check():
    global prim, Closed
    if not prim:
         SM_CurvesOperations()
         
@d_submenu("SM_CurvesOperations")
def SM_CurvesOperations():
            coat.menu_item("SeparateDisconnectedCurves")
            coat.menu_item("SM_SplitSelfIntersections")
            coat.menu_item("SM_BooleanOperations")
            coat.menu_item("SM_SimplifyCurve")
            coat.menu_item("SM_SmoothingCurve")
            coat.menu_item("SM_RemoveSharp")
            coat.menu_item("SM_SubdivideCurve")
            coat.menu_item("SM_ReverseCurveDirection")
            coat.menu_item("SM_PointsExtrude")
            coat.menu_item("SM_ClearSymmetryDependency")
    

@d_menu_section(CurvesRMB)
def S_OverSculptObject():
    if coat.menu_property("OverSculptObject"):
        coat.menu_item("RichSplitObjectByCurve")
        coat.menu_item("BevelOverCurve")

@d_menu_section(CurvesRMB)
def S_Brush():
    coat.menu_item("RunBrushAlongCurve")
    coat.menu_item("RunBrushAlongProjection")
    coat.menu_item("EditPressuerProfile")

@d_menu_section(CurvesRMB)
def S_Projection():
    global prim, Closed
    if Closed:
        coat.menu_item("FillInsideInProjection")

    coat.menu_item("SelectInProjection")
    if Closed and coat.IsInRoom("Voxels"):
        coat.menu_item("SelectIn3D")

    if coat.IsInRoom("Voxels"):
        coat.menu_item("CreateFromSelectionEdge")

@d_menu_section(CurvesRMB)
def S_Surface():
    coat.menu_item("ActiveCurveModifiers") # /ActiveCurveModifiers
    coat.menu_item("CoverWithSurfaceObject") # /Fill with mesh layer
    coat.menu_item("TubeOrModels") # /Attach tube or models array
    coat.menu_item("BendVolume") # /Bend Volume
    coat.menu_item("CreateSweptSurface") # /Swep profile along Giude Curve
    coat.menu_item("CreateRotateSurface") # /Create Rotate Surface
    coat.menu_item("CreateSurfacePrism") # /Create Polyhedron
    coat.menu_item("CreateSweptSurface2Guide") # /Create Swept Surface 2 Guide
    coat.menu_item("CreateSweptSurface2Geners") # /Create Swept Surface 2 Geners
    coat.menu_item("CreateSweptSurfaceNGeners") # /Create Swept Surface N Geners
    coat.menu_item("CreateProfileAlongGuide") # /Create Profile Along Guide

@d_menu_section(CurvesRMB)
def S_Settings():
    # CurveModifier::RegInMenu(this, Prop);
    if coat.IsInRoom("Retopo"):
        coat.menu_item("CreateFromSelectedEdges")
        coat.menu_item("CreateFromOpenEdges")

    coat.menu_item("AttachToSurface")
    CurveSettings()
    coat.menu_item("DeleteItem")

@d_submenu("CurveSettings")
def CurveSettings():
    global prim, Closed
    if not prim:
        coat.menu_item("ClosedCurve")

    coat.menu_item("ShowRadiuses")
    coat.menu_item("LockRadius")
    coat.menu_item("ShowNormals")
    coat.menu_item("LockNormals")
    coat.menu_item("ShowPoints")
    coat.menu_item("SnapToSurfaces")
    if not prim:
        coat.menu_item("KeepInPlane")

    coat.menu_item("SM_ShowLength")
    coat.menu_item("SameRadius")
    coat.menu_item("ChangeCurveColor")
