# 
# The Free Surface room toolset definition.
#
# Insert commands and conditions within the main(){...} function
# use
#   tools_item("IdentifierOfTheTool");
# to add new item into the toolset.
# use
#   tools_section("Section name");
# to add tools section.
# The command
#   default_tool("IdentifierOfTheTool");
# defines the tool used by default in the room.
# 
# 
import coat
from cTemplates.Structs import *

Tools = cTemplate()

@d_child(Tools)
def Mesh_to_NURBS_Comment():
   coat.tools_comment("Mesh to NURBS")

@d_tools_section("Basic", Tools)
def Basic():
   coat.default_tool("[extension]MdlSelectTool")
   coat.tools_item("[extension]MdlSelectTool") # SelectTool
   coat.tools_item("{RTPPRIM}[extension]RTP_PRIM") # 3DPrimitives
   coat.tools_item("{RTPPRIM}[extension]RTP_PRIM2") # 2DPrimitives
   coat.tools_item("[RetopoTool]TopToolSelectAndOperate") # Select
   coat.tools_item("[extension]MdlSurfacePatch") # Surface Patch
   coat.tools_item("[extension]SurfaceUnitTool") # To NURBS Surface 
   coat.tools_item("[extension]MdlRootSurface") # RootSurface
   coat.tools_item("[extension]LoftedSurface") # Lofted Surface
   coat.tools_item("[extension]FillingSurface") # Filling Surface
   coat.tools_item("[extension]MdlCoveringSurfaces") # Covering Surfaces
   coat.tools_item("[extension]MdlRuledSurface") # Ruled Surface
   coat.tools_item("[extension]SurfaceToMesh") # Surface To Mesh


@d_tools_section("EditGeometry", Tools)
def EditGeometry():
   coat.tools_item("[extension]UnitSurfaces") # Unit Surfaces
   coat.tools_item("[extension]MdlExtractEdge") # Extract Edge
   coat.tools_item("[extension]SnapSurfaces") # Snap Surfaces
   coat.tools_item("[extension]SmoothingTwoSurfaces") # Smoothing Two Surfaces
   coat.tools_item("[extension]SymmetrySurface") # Symmetry Surface

@d_tools_section("WholeSurfaces", Tools)
def WholeSurfaces():
   coat.tools_item("[extension]ExportIgesSurfaces") # Export
   coat.tools_item("[extension]ImportIgesSurfaces") # Import
   coat.tools_item("[extension]AnalyzeSurfaces") # Analyze Surfaces



