/*-------------------------------------------*/
// Mission 5
// Purpose: Painting / Depth / Color / Gloss
// File: PaintChannels.as
/*-------------------------------------------*/

Debug     dbg;
DebugLog  logger = dbg.log();

string orange_Color = "4292730333";
string mission_Abort = "Mission_Abort";
string mission_Complete = "Mission_Complete";

int codeDone  = 0;
int N0 = 0;
int NMAX = 1;
int NI = 0;
int NCount = 0;

void GoToStartMission() {
	cmd("$CLEARSCENE");
	cmd("$START_MENU_smMission");
}

string GetCommandMessage(string explainMessage,int idx){
  int X0 = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
  int Y0 = 8 * GetWorkAreaHeight() / 100;
  string abort = GetTextID("ABORT");
  string cmd_MSG = "";
  cmd_MSG += X0;
  cmd_MSG += ";";
  cmd_MSG += Y0;
  cmd_MSG += ";";
  cmd_MSG += GetTextID(explainMessage);
  cmd_MSG += ";1";
  cmd_MSG += ";";
  cmd_MSG += orange_Color;
  cmd_MSG += ";0";
  if ( (idx & 1) == 1) {
	cmd_MSG += ";1,0,0,data//Textures//arrowback.png,0,";
	cmd_MSG += orange_Color;
	cmd_MSG += ",0";
  }
  cmd_MSG += ";0,0,0,";
  cmd_MSG += abort;
  cmd_MSG += ",1,";
  cmd_MSG += orange_Color;
  cmd_MSG += ",0";
  if ((idx & 2) == 2) {
	cmd_MSG += ";2,0,0,data//Textures//arrowforward.png,2,";
	cmd_MSG += orange_Color;
	cmd_MSG += ",0";
  }
  return cmd_MSG;
 }

 void main() {
  UI  ui;
   
  logger.clear();
  logger += "Start CLEARSCENE";

  string mission_Explain = "PaintModes_Explain";
  string explain_Depth = "PaintDraw_Depth";
  string explain_Color = "PaintDraw_Color";
  string explain_Specular = "PaintDraw_Specular";
  
  SetShowModalDlg(false);
	
  ui.enableWindow("STARTMENU", false);
   
  ui.enableWindow("Layers_SINGLE",false);
  
  cmd ("$SETPAGE_Paint");
  
  DeletePaintLayers();
  
  ppp("data/Samples/sphere.obj");
  
  SetShowModalDlg(true);
  
  SetSliderValue("$PEN_RADIUS",30);
  SetSliderValue("$PEN_DEPTH",50);
  SetSliderValue("$PEN_MASK",30);

  cmd ("$PENOP0");
  cmd ("$StdPen");
  cmd ("$StopEditCurves");

  int FontID = GetFontFileID("Fira_Sans_Condensed_16");
  
  int X0 = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
  int Y0 = 8 * GetWorkAreaHeight() / 100;
  
  SetFloatingMessageBox(X0, Y0, mission_Explain,orange_Color,1);
  
  bool noExit = true;
  int istatus = 3;
  
  while(noExit) {
	Step(1);
	HighlightUIElement("$PEN_TOGGLE_MASK_HINT",0.1);
	HighlightUIElement("$PEN_TOGGLE_DEPTH_HINT",0.1);
	HighlightUIElement("$PEN_TOGGLE_SPEC_HINT",0.1);
	
	float X = GetMouseX();
	float Y = GetMouseY();
	if(LMBPressed()){
		istatus = ScriptMessagePressButton(X,Y);
		if (istatus == 0) { noExit = false; } //abort
	}
	if (IsPressKeyID(0x0D)) {
        noExit = false;
		istatus = 1;
	}	
  }
  SetScriptMessage("reset","");
  if ( istatus > 0) { 
	noExit = true; 
	istatus = 3;
	EnablePenChannel(0,false);
	EnablePenChannel(1,false);
	EnablePenChannel(3,false);
  }
  int statusFinish = 0;
  while (noExit && (istatus > 0)) {
	Step( 1 ); //Rendering cycle
	if (istatus == 0 || istatus == 2) { noExit = false; break; }
	string cmd_MSG;
	if (istatus == 3) { 
		NI = 1;
		EnablePenChannel(1,false);
		cmd_MSG = GetCommandMessage(explain_Color,2);
		istatus = HighlightUIElements("$PEN_TOGGLE_MASK_HINT",2,cmd_MSG,1,"PEN_ChannelPressed",false);
	}
	if (istatus == 4 || istatus == 2){
		NI = 0;
		if ( istatus == 2) {
			statusFinish |= 0x01;
			SetFloatingMessage(X0,Y0,"Well_Done",orange_Color);
			Wait( 2000 );
			SetScriptMessage("reset","");
		} else { Wait( 500 );}
		EnablePenChannel(0,false);
		cmd_MSG = GetCommandMessage(explain_Depth,3);
		istatus = HighlightUIElements("$PEN_TOGGLE_DEPTH_HINT",2,cmd_MSG,1,"PEN_ChannelPressed",false);	
	}
	if (istatus == 4 || istatus == 2){
    	NI = 3;
		if ( istatus == 2) {
			statusFinish |= 0x02;
			SetFloatingMessage(X0,Y0,"Super",orange_Color);
			Wait( 2000 );
			SetScriptMessage("reset","");
		} else { Wait( 500 );}
		EnablePenChannel(3,false);
		cmd_MSG = GetCommandMessage(explain_Specular,1);
		istatus = HighlightUIElements("$PEN_TOGGLE_SPEC_HINT",2,cmd_MSG,1,"PEN_ChannelPressed",false);
		if ( istatus == 3) istatus = 4;
		if ( istatus == 2) {
			statusFinish |= 0x04;
			SetFloatingMessage(X0,Y0,"Excellent",orange_Color);
			Wait( 2000 );
			SetScriptMessage("reset","");
		}
	}
  }
 
  int XC = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
  int YC = GetWorkAreaHeight() / 2;
 	
  if ((statusFinish & 0x07) == 0x07) { 
    Wait( 500 );
	SetFloatingMessageBoxTime(XC, YC, mission_Complete, orange_Color,0,5000);
	logger += "End Mission";
  } else {
  	SetFloatingMessage(XC,YC,mission_Abort,orange_Color);
  }
   Wait( 5000 );
   
   EnablePenChannel(0,true);
   EnablePenChannel(1,true);
   EnablePenChannel(3,true);
	
   SetScriptMessage("reset","");
   
   ui("$LayersPanel::TrashLayer");
   
   ui.enableWindow("Layers_SINGLE",false);
   SetShowModalDlg(false);
   GoToStartMission();
   SetShowModalDlg(true);
   logger.clear();
   logger += "End Mission";
 }
 
 int PEN_ChannelPressed(int i) {
 if(!IsEnabledPenChannel(NI)) return 0;
  if(IsDrawPen()) {
    NCount++;
    logger += "PEN_DRAW";
 }
  if(NCount > NMAX) {
     NCount = 0;
	 return 2;
  } else return 1;
  return 0;
 }
 
 // Is drawing pen in object
bool IsDrawPen() {
bool isDraw = false;
bool bFirst = true;
float xStart,yStart;

float X = GetMouseX();
float Y = GetMouseY();
bool bObj = ScreenRayPicksObject(X,Y);
bool bAlt = Alt();
while (LMBPressed() && bObj && (!bAlt) )
{
    Step(1);
  	if(bFirst){
	    xStart=GetMouseX(); 
        yStart=GetMouseY();
		bFirst=false;
	}
    float x=GetMouseX(); 
    float y=GetMouseY();
    float r = sqrt( (x-xStart)*(x-xStart) + (y-yStart)*(y-yStart) );
	if (r > 50) {
		isDraw = true;
		break;
	}
}
return isDraw;
}