/*--------------------------------------------------------------*/
// Mission 2
// Purpose: The brush selection.
// File: Brushes.as
/*--------------------------------------------------------------*/

Debug     dbg;
DebugLog  logger = dbg.log();

string mission_Explain_ID = "Brushes_Explain"; 
string mission_Complete_ID = "Mission_Complete";
string mission_No_Complete_ID = "Mission_Not_Complete";
string mission_Abort = "Mission_Abort";

string orange_Color = "4292730333";
string cmd_MSG = "";
int codeDone  = 0;
int X0 = 0;
int Y0 = 0;

void GoToStartMission() {
	cmd("$SETPAGE_3DPrint");
	cmd("$CLEARSCENE");
	cmd("$START_MENU_smMission");
}

 void main() {
  UI  ui;
  int FontID = GetFontFileID("Fira_Sans_Condensed_16");
  
  X0 = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
  Y0 = 8 * GetWorkAreaHeight() / 100;
  
  ShowMessageWhilePressKey(X0, Y0, mission_Explain_ID, orange_Color, 0x0D,"");
  
  logger.clear();
  logger += "Start CLEARSCENE";
  
  ui.enableWindow("STARTMENU", false);
  
  SculptLayer sl;
  SculptRoom  room;
  
  cmd ("$SETPAGE_Simplest");
  cmd ("$StopEditCurves");

  room.clear();

  Builder  builder;
  
  // Load gear 
  Mesh b = builder.gear().startPoint(0).endPoint(40).topRadius(20).bottomRadius(20).height(30).relativeHoleRadius(0.5).depth(0.1).sharpness(0.5).teeth(16).build();
  
  auto  transform = b.tools().transform();
  
  const Vec3 sc(10.0);
  
  transform.scale(sc)();
  room += b;
  
  sl.rename( "Gear" );
  
  cmd("$VoxTreeBtn6");
  cmd("$PENOP0");
  cmd("$SCULP_SCLAY");
  
  int istatus = 1;
  int idraw = 0;
  bool quit = false;
  int state = 0;
  while (!quit) {
	Step(1);
	
	if (istatus == 1) istatus =	CheckBrushSize();
	if (istatus == 2) {
		if ( state!=2 ) {
			idraw = DrawBrush(0);
			if(idraw==2) istatus = CheckBrushDepth();
			else if (idraw==1)istatus = 1; else istatus=0;
		} else istatus = CheckBrushDepth();
		state = 1;
	}
	if (istatus == 3) {
		if ( state!=3 ) {
			idraw = DrawBrush(1);
			if(idraw==2) istatus = CheckBrushSmoothing();
			else if(idraw==1) istatus = 2; else istatus = 0;
		} else istatus = CheckBrushSmoothing();
		state = 2;
	}
	if (istatus == 4) {
	    idraw = DrawBrush(2);
		if(idraw==2) istatus = CheckBrushRotation();
		else if(idraw==1) istatus = 3; else istatus = 0;
		state = 3;
	}
	if (istatus == 0 || istatus == 5) { quit == true; break;}
 }
   
  logger +=  istatus;
  int X = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
  int Y = GetWorkAreaHeight() / 2;
  if ( istatus > 0)  {
	Wait( 1000 );
	if (codeDone  == 15) 
	{
		SetFloatingMessageBoxTime(X, Y, mission_Complete_ID, orange_Color,0,5000);		
	} else {
		SetFloatingMessageBoxTime(X, Y, mission_No_Complete_ID, orange_Color,0,5000);
	}
	logger += "End Mission";
	room.clear();
	SetShowModalDlg(false);
	GoToStartMission();
	SetShowModalDlg(true);
  } 
  else {
		SetFloatingMessage(X, Y, mission_Abort, orange_Color);
		Wait( 3000 );
		SetScriptMessage("reset","");
		logger += "Abort Mission";
		room.clear();
		SetShowModalDlg(false);
		GoToStartMission();
		SetShowModalDlg(true);
  }
 }
 
 // check press 
 int GetPressButton(){
	int Status = -1;
	if(LMBPressed()){
		float x=GetMouseX(); 
		float y=GetMouseY();
		Status = ScriptMessagePressButton(x,y);
	}
	return Status;
} 

int DrawBrush(int idx) 
{
  string msg_draw;
  int ds = 100;
  if(idx == 0) {
	msg_draw = "Change_Brush_Size_Draw";
 } else if (idx==1){
	msg_draw = "Change_Brush_Depth_Draw";
    ds = 120;
 } else {
	msg_draw = "Change_Brush_Smooth_Draw";
	ds = 150;
 }
  int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
  int YY = 8 * GetWorkAreaHeight() / 100;
	
  SetFloatingMessageBox(XX, YY, msg_draw, orange_Color,4);
  bool noExit = true;
  int iret = 0;
  int nstatus = 0;
  bool bFirst = true;
  float xStart;
  float yStart;
  
  while(noExit) {
    Step(1); //Rendering cycle
	int istatus = GetPressButton();
	if (istatus!=-1) {
		noExit = false;
		iret = istatus;
	} else {
		if(nstatus > 1) {
			noExit = false;
			iret = nstatus;
		}
	}
	while (LMBPressed()) { 
		Step(1);
		float x=GetMouseX(); 
		float y=GetMouseY();
		bool bObj = ScreenRayPicksObject(x,y);
		if (bObj) {
			if(bFirst){
				xStart=GetMouseX(); 
				yStart=GetMouseY();
				bFirst=false;
			}
			float x=GetMouseX(); 
			float y=GetMouseY();
			if (abs(x-xStart) > ds || abs(y-yStart) > ds) {
				nstatus++;
				bFirst=true;
				break;
			}   
		}
		if (IsPressKeyID(0x1B)) {
			noExit = false;
		}
	}
	bFirst=true;
 } 
 if (nstatus > 0) {
	SetScriptMessage("reset","");
 	SetFloatingMessage(XX,YY,"Well_Done",orange_Color);
	Wait( 2000 );
 }
 
 SetScriptMessage("reset","");
 return iret;
}
 // 1 method
int CheckBrushSize() {
  bool bFirst = true;
  bool noExit = true;
  int statusOK = 0;
  string explain = "Change_Brush_Size";
  float xStart;
  float yStart;
  
  int iret = 2; // 2 method next 
	
  int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
  int YY = 8 * GetWorkAreaHeight() / 100;
  
  cmd("$[Page4]Buildup");
  SetFloatingMessageBox(XX, YY, explain, orange_Color,3);
  while(noExit) {
    Step(1); //Rendering cycle
	int istatus = GetPressButton();
	bool bObj = true;
	if (istatus!=-1) {
		noExit = false;
		iret = istatus;
	}
	if (RMBPressed()){
		if(bFirst){
		    xStart = GetMouseX(); 
            yStart = GetMouseY();
			bObj = ScreenRayPicksObject(xStart,yStart);
			bFirst = false;
		}
	}
	while (RMBPressed()) { 
		Step(1);
		float x=GetMouseX(); 
		float y=GetMouseY();
		if (bObj) {
			float x1=GetMouseX(); 
			float y1=GetMouseY();
			if (abs(x1-xStart) > 20) {
				statusOK |= 1;
				break;
			}   
		}
		if (IsPressKeyID(0x1B)) {
			noExit = false;
		}	
	}
	while (WheelPressed()) { 
	 	Step(1);
		float x=GetMouseX(); 
		float y=GetMouseY();
		bool bObj = ScreenRayPicksObject(x,y);
		if (bObj) {
			statusOK |= 2;
			break;
		}
	}
	bFirst = true;
	if (IsPressKeyID(0x1B)) noExit = false;
    if ( (statusOK & 0x03) == 0x03 ) {
	 	SetScriptMessage("reset","");
 		SetFloatingMessage(XX,YY,"Well_Done",orange_Color);
		Wait( 2000 );
		noExit = false;
		codeDone += 0x1;
	} 
  } 
  SetScriptMessage("reset","");
  return iret;
 }


// 2 method
int CheckBrushDepth() {
  bool bFirst = true;
  bool noExit = true;
  int statusOK = 0;
  string explain = "Change_Brush_Depth";
  float xStart;
  float yStart;
  
  int iret = 3;  // next method
  
  int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
  int YY = 8 * GetWorkAreaHeight() / 100;
  
  cmd("$[Page4]Buildup");
  SetFloatingMessageBox(XX, YY, explain, orange_Color,4);
  while(noExit) {
    Step(1); //Rendering cycle
	int istatus = GetPressButton();
	bool bObj = true;
	if (istatus!=-1) {
		noExit = false;
		if (istatus == 1) iret = 1;
		if (istatus == 2) iret = 3;
		if (istatus == 0) iret = 0;
	}
	if (RMBPressed()){
		if(bFirst){
		    xStart = GetMouseX(); 
            yStart = GetMouseY();
			bObj = ScreenRayPicksObject(xStart,yStart);
			bFirst = false;
		}
	}
	while (RMBPressed()) { 
		Step(1);
		if (bObj) {
			float x=GetMouseX(); 
			float y=GetMouseY();
			if (abs(y-yStart) > 40) {
				statusOK = 1;
				noExit = false;
				break;
			}   
		}
		if (IsPressKeyID(0x1B)) {
			noExit = false;
		}	
	}
	bFirst = true;
	if (IsPressKeyID(0x1B)) noExit = false;
 }
    if ( (statusOK & 0x01) == 0x01 ) {
		SetScriptMessage("reset","");
		SetFloatingMessage(XX,YY,"Very_Good",orange_Color);
		codeDone += 0x2;
		Wait( 2000 );
	}
	SetScriptMessage("reset","");
	return iret;
}
// 3 method
int CheckBrushSmoothing() {
  bool bFirst = true;
  bool noExit = true;
  float xStart;
  float yStart;
  string explain = "Change_Brush_Smooth"; 
  
  int iret = 4; // next 4 method
  
  int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
  int YY = 8 * GetWorkAreaHeight() / 100;
  
  int statusOK = 0;
  
  cmd("$[Page4]Draw");
  SetFloatingMessageBox(XX, YY, explain, orange_Color,4);
  while(noExit) {
    Step(1); //Rendering cycle
    bool shiftKey = IsPressKeyID(0x10);
	int istatus = GetPressButton();
	bool bObj = true;
	if (istatus!=-1) {
		noExit = false;
		if (istatus == 1) iret = 2;
		if (istatus == 2) iret = 4;
		if (istatus == 0) iret = 0;
	}
	if (RMBPressed()){
		if(bFirst){
		    xStart = GetMouseX(); 
            yStart = GetMouseY();
			bObj = ScreenRayPicksObject(xStart,yStart);
			bFirst = false;
		}
	}
	
	while (RMBPressed() && shiftKey) { 
		Step(1);
		if (bObj) {
			float x=GetMouseX(); 
			float y=GetMouseY();
			if (abs(y-yStart) > 40) {
				statusOK = 1;
				noExit = false;
				break;
			}   
		}
		if (IsPressKeyID(0x1B)) {
			noExit = false;
		}	
	}
	bFirst = true;
	if (IsPressKeyID(0x1B)) noExit = false;
 }
 	if ( (statusOK & 0x01) == 0x01 ) {
		SetScriptMessage("reset","");
		SetFloatingMessage(XX,YY,"Kudos",orange_Color);
		codeDone += 0x4;
		Wait( 2000 );
	}
	SetScriptMessage("reset","");
	return iret;
}

// 4 method
int CheckBrushRotation() {
  bool bFirst = true;
  bool noExit = true;
  string explain = "Change_Brush_Rotation";
  
  int iret = 5; // exit success
  
  int XX = GetWorkAreaWidth() / 2 + GetWorkAreaLeft();
  int YY = 8 * GetWorkAreaHeight() / 100;
  int statusOK = 0;
  //Show non-modal message
  SetFloatingMessageBox(XX, YY, explain, orange_Color,2);
  while(noExit) {
    Step(1); //Rendering cycle
    bool ZeroKey = IsPressKeyID(48);
	bool NineKey = IsPressKeyID(57);
	
	int istatus = GetPressButton();
	if (istatus!=-1) {
		noExit = false;
		if (istatus == 1) iret = 3;  // pred
		if (istatus == 0) iret = 0; //  abort
	}
	while (ZeroKey || NineKey) { 
		Step(1);
		float x=GetMouseX(); 
		float y=GetMouseY();
		bool bObj = ScreenRayPicksObject(x,y);
		if (bObj) {
			if ( ZeroKey ) statusOK |= 1;
			if ( NineKey ) statusOK |= 2;
		}
		ZeroKey = IsPressKeyID(48);
		NineKey = IsPressKeyID(57);
		if (IsPressKeyID(0x1B)) {
			noExit = false;
		}	
	}
	if (IsPressKeyID(0x1B)) noExit = false;

	if ( (statusOK & 0x03) == 0x03 ) {
		SetScriptMessage("reset","");
		SetFloatingMessage(XX,YY,"Excellent",orange_Color);
		Wait( 2000 );
		noExit = false;
		codeDone += 0x8;
	}
 }
 SetScriptMessage("reset","");
 return iret;
}
 
 // VK_OEM_4 [
 // VK_OEM_6 ]