#!/usr/bin/env python3
"""! @brief 3DCoat python API documentation."""
##
# @mainpage 3DCoat Python API
#
# @section description_main Description
# The 3DCoat Python API is intended to trigger UI commands, operate over the scene, and create new tools.
# It is very similar to the C++ Core API, but has its own advantages and drawbacks. 
# - No need for any additional setup to make your scripts; Python is embedded into the 3DCoat distributive. 
# - Python is like a Swiss-knife, allowing you to bring the whole power of Python libraries into 3DCoat. 
# - Python is much slower than C++, so it may be used only for general management, not for deep and complex algorithms. 
# - If you are already familiar with the C++ Core API, the Python API is very similar, almost 1:1, with the same logic and function names.
#
# @section usage_py Usage
# - Use **Scripts->Create Python Script** to create a new script. You may choose an initial template to start (it will be created in the 3DCoat\UserPrefs\PythonAPI\UserProjects folder). The .py file will open in your current editor associated with .py files.
# - We use embedded Python 3.8.10 to operate. This is the last Python version that may run on Windows 7.
# - If needed, you may create a file called requirements.txt with a list of used modules; in this case, the modules will be auto-installed before the script runs.
# - We recommend Visual Studio Code, as it will automatically recognize 3DCoat-specialized commands syntax and offer the correct hints.
# - Use **Scripts->Show Python Console** to see the console output from Python. If the PythonTerminal plugin is disabled, do not close the console window, this will close all of 3DCoat! See the **Debugging** section to understand the debugging with the VisualStudio Code.
# - You may install additional packages for Python using **Scripts->Install python packages**. Another way is to use **requirements.txt** in the same folder as the .py file's location.
#
# @section debugging Debugging
# You can debug the Python script using Visual Studio Code. Create the project using **Scripts -> Create Python Script**. The project consists of **your_project_name.py** (your script), **.env** paths to the 3DCoat API libraries, 
# and **launch.json** in the .vscode folder (run/debug settings).
# PORT will be automatically configured every time you start 3DCoat if the project is in 3DCoat/UserPrefs/Scripts/Extensions or UserPrefs/PythonAPI/UserProjects or UserPrefs/Addons
# so if you run multiple 3DCoat executions at the same time, the debugger will only work with the last 3DCoat run. In this case, you can always automatically configure the debugger in the projects for any 3DCoat process using the menu item **Scripts -> Attach to Python Debugger**, also this function can be used if you copy or create a new python project manually after starting 3DCoat it will configure the project
#
# The project will open in Visual Studio Code if it is installed. You may also open the project folder manually from VS Code.\n
#
#
# In VS Code, select the .py file, then press **F5** to start debugging. A dropdown list will appear; select **3DCoatGL64.exe**.\n
# <img src="dbg_attach.png">
# VS Code will try to connect to the 3DCoat process. if attached successfully, you will see the debugging controls at the top: <img src="vs_code_connected.png" width="180">. 
# 
# Now set breakpoints in VS Code, then run your script from 3DCoat's scripts menu. The script will stop at the breakpoint. Now you may watch variables, debug step by step, etc.
#
# @section main_classes Main classes
# General I/O: coat.io\n
# Dialog management: coat.dialog\n
# Mesh operations: coat.Mesh\n
# Retopo/Modeling operations: coat.Model\n
# UV operations: coat.uv\n
# Scene roots: coat.Scene\n
# Scene element: coat.SceneElement\n
# Volume management: coat.Volume\n
# UI management: coat.ui\n
# 2D-vectors math: coat.vec2\n
# 3D-vectors math: coat.vec3\n
# 4D-vectors math: coat.vec4\n
# 3D-matrix math: coat.mat3\n
# 4D-matrix math: coat.mat4\n
# Bounds management: coat.box\n
# Rectangles management: coat.rect\n
# Symmetry management: coat.symm \n
# Resources management: coat.resource \n
# Settings: coat.settings \n
# @section copyref Copy vs Reference
# Any object like vec2, vec3, vec4, mat..., any other may be copied as reference or as value. If you write something like this:\n
# @code
# from coat import *
# v1=vec3(1,2,3)
# v2=v1
# v2.x=5
# print(v1.x, v2.x)
# @endcode
# You will see 5.0 5.0, because v1 and v2 are the same object. If you want to copy the object as value, you should write something like this:\n
# @code
# from coat import *
# v1=vec3(1,2,3)
# v2=vec3(v1)
# v2.x=5
# print(v1.x, v2.x)
# @endcode
# You will see 1.0 5.0, because v2 is a copy of v1.\n
# This is true for almost all 3DCoat's objects (where is has logical sense), not only for vectors.
# @section addons Addons
# The add-on mechanism is a way to extend the 3DCoat functionality and share it with another user. Since the 3DCoat 2024, there has been an Addons menu in the main menu. Get there, see the Examples section, and look at the Readme. 
# You may add your own scripts to that menu. Click the "..." button in any submenu and see the available options. You may add your submenu, script, readme, license, funding information, and links. 
# Also, you may create redistributable packages right in that menu. If a user installs the package, the corresponding scripts will appear in the Addons menu. Hotkey may be assigned to any script. 
# The Addons menu follows the folder structure in the UserPrefs/Addons/ folder. Exception is folders and files that start from "." or "_". They are ignored. 
# Both - CoreAPI and Python scripts may be placed in the Addons menu. Each script and its additional files should be placed in a separate folder. That folder will not be shown in the Addons menu, only the scripts itself will be referred.
# @section submodules Using muliple files in the project
# It is important not to place the additional data files right in the folder with the main .py file. We recommend placing them in a subfolder like "_data".
# You can place additional .py files in the same folder as the main .py file or in a subfolder. If you prefer these to not appear in the Addons, place them in a folder that starts with "_" or prefix the submodule filenames with "_", such as "_my_submodule.py".
# Submodules can be imported as follows:
# @code
# import _my_submodule
# # or
# from _my_submodule import *
# # or, if the submodule my_submodule.py is located in a folder named _my_folder
# from _my_folder import my_submodule
# @endcode
# Note that when you run the main .py files, the submodules are not reloaded if they have already been loaded. To reload a submodule, you should use the reload function from the importlib module:
# @code
# import _my_submodule
# # To reload the _my_submodule during development, use the following snippet. 
# # This can be removed once development is completed.
# import importlib
# importlib.reload(_my_submodule)
# @endcode
# In the case of a submodule located in a subfolder, you should use the following snippet:
# @code
# from _my_folder import my_submodule
# # The reloading code:
# import importlib
# importlib.reload(my_submodule)
# @endcode
# @section extensions Extensions
# <img align="right" src="extensions_ui.png"> 
# 3DCoat has a mechanism for creating and installing extensions that can run with the application and control all its events.
# To open the extension manager window, use the main menu Windows->Panels->Extensions
# To launch the extension, click the "Start" button. If you want to automatically launch the extension with 3DCoat, make sure the box is checked.
# All native 3DCoat modules are located in the 3D Coat installation folder UserPrefs\Scripts\Modules and can be used from other scripts using the include method in the Modules section. 
# @code
# from Modules.PythonTerminal import PythonTerminalExt
# @endcode
# All user extensions and installed extensions are located in the user's documents folder UserPrefs\Scripts\Extension and can be used from other scripts using the include method in the Extension section.
# @code
# from Extension.MY_EXTENSION import MY_MODULE
# @endcode
# Please note that some extensions require installation of necessary Python modules on first launch, they will need an internet connection for this, if you do not have an internet connection on first launch, the extension module will not start. You may see a red message in the status bar when the module is in the process of installation.
# @section console Console Usage
# You can use the console to view the output of the print() function. The console can be opened via **Scripts -> Show Python Console**.
# However, you can also open it directly from a script using the coat.io.showPythonConsole() function. In this case, the console pops up and will be cleared automatically. This is useful for debugging purposes.
# @section Examples
# Looking the \ref examples is the best way to understand the API. Use **Scripts->Create new Python script** to experiment with that examples.
# @subsection Basic
# <div class="sample"><img src="HelloWorld.png"><div>\link HelloWorld.py \endlink<br>The Hello World!</div></div>
# <div class="sample"><img src="insert_in_menu.png"><div>\link insert_in_menu.py \endlink<br>Insert item into the menu!</div></div>
# <div class="sample"><img src="insert_in_toolset.png"><div>\link insert_in_toolset.py \endlink<br>Insert item into the toolset!</div></div>
# <div class="sample"><img src="ui_command.png"><div>\link ui_command.py \endlink<br>The UI management example.</div></div>
# <div class="sample"><img src="dialogs.png"><div>\link dialogs.py \endlink<br>The dialog creation example.</div></div>
# <div class="sample"><img src="resources_test.png"><div>\link resources_test.py \endlink<br>Resources management (Alphas, Stencils, ....)</div></div>
# @subsection Scene
# <div class="sample"><img src="square_volume.png"><div>\link square_volume.py \endlink<br>Iterate over the sculpt tree, show the basic stats - square, volume</div></div>
# @subsection Meshes
# <div class="sample"><img src="meshes_primitives.png"><div>\link meshes_primitives.py \endlink<br>Meshes and primitives</div></div>
# <div class="sample"><img src="cut_by_plane.png"><div>\link cut_by_plane.py \endlink<br>Break the object into pieces</div></div>
# <div class="sample"><img src="Break_mesh_by_cracks.png"><div>\link Break_mesh_by_cracks.py \endlink<br>Break the current volume with realistic cracks</div></div>
# @subsection Generators
# <div class="sample"><img src="GeneratorExample.png"><div>\link GeneratorExample.py \endlink<br>Non-destructive geometry generator example</div></div>
# @subsection Primitives
# <div class="sample"><img src="WindRose.png"><div>\link WindRose.py \endlink<br>Generate the surface figure "windrose" that consists of cones</div></div>
# <div class="sample"><img src="capsule.png"><div>\link capsule.py \endlink<br>This example generates the surface figure that consists of capsule</div></div>
# <div class="sample"><img src="HelloWorld3D.png"><div>\link HelloWorld3D.py \endlink<br>Generate the text primitive</div></div>
# @subsection UV
# <div class="sample"><img src="uv_to_sculpt.png"><div>\link uv_to_sculpt.py \endlink<br>Get UV-s from the UV room and convert them to the sculpt room objects</div></div>
# <div class="sample"><img src="uv_random_rotation.png"><div>\link uv_random_rotation.py \endlink<br>Randomly rotate the UV islands and pack them</div></div>
# <div class="sample"><img src="uv_to_cloth.png"><div>\link uv_to_cloth.py \endlink<br>Convert uv islands to the cloth pieces with extra borders to be sewed together</div></div>
# <div class="sample"><img src="uv_stats.png"><div>\link uv_stats.py \endlink<br>Calculate the square thash for the UV islands</div></div>
# @subsection Modeling
# <div class="sample"><img src="random_spheres.png"><div>\link random_spheres.py \endlink<br>create random spheres in retopo room, then remove one of groups, collapse edges randomly</div></div>
# <div class="sample"><img src="hairy_sphere.png"><div>\link hairy_sphere.py \endlink<br>This is example just to discover operations over meshes in the retop room. There we create random spheres in retopo rool, delete one of groups, select random faces, extrude them and move along normals.</div></div>
# <div class="sample"><img src="virus.png"><div>\link virus.py \endlink<br>Low-poly virus modeling</div></div>
# @subsection Export
# <div class="sample"><img src="auto_export.png"><div>\link Autoexport.py \endlink<br>The script used for the File->Export->Decimate > Auto UV-Map > Export</div></div>
# @subsection Render
# <div class="sample"><img src="render_with_shadow.png"><div>\link render_with_shadow.py \endlink<br>Render object from the random top view with random light position. The object rendered as if it drops the shadow on the invisible plane. The shadow represented as the alpha channel of the final image.</div></div>

## @example HelloWorld.py
# The simplest Hello World!
# ![HelloWorld](HelloWorld.png)

## @example insert_in_menu.py
# Insert the command into the menu
# ![HelloWorld](insert_in_menu.png)

## @example insert_in_toolset.py
# Insert the command into the Sculpt toolset
# ![HelloWorld](insert_in_toolset.png)

## @example ui_command.py
# Running the UI commands
# ![ui_command](ui_command.png)

## @example resources_test.py
# Resources management
# ![ui_command](resources_test.png)

## @example dialogs.py
# Running the UI commands
# ![dialogs](dialogs.png)

## @example square_volume.py
# Iterate over the sculpt tree, show the basic stats - square, volume
# ![square_volume](square_volume.png)

## @example meshes_primitives.py
# Meshes and primitives
# ![meshes_primitives](meshes_primitives.png)

## @example cut_by_plane.py
# Cut the current object inte random pieces
# ![cut_by_plane](cut_by_plane.png)

## @example WindRose.py
# Generate the surface figure "windrose" that consists of cones
# ![WindRose](WindRose.png)

## @example HelloWorld3D.py
# Generate the text primitive
# ![HelloWorld3D](HelloWorld3D.png)

## @example capsule.py
# This example generates the surface figure that consists of capsule
# ![capsule](capsule.png)

## @example GeneratorExample.py
# Non-destructive geometry generator example
# ![GeneratorExample](GeneratorExample.png)

## @example uv_to_sculpt.py
# Get UV-s from the UV room and convert them to the sculpt room objects
# ![uv_to_sculpt](uv_to_sculpt.png)

## @example uv_random_rotation.py
# Randomly rotate the UV islands and pack them
# ![uv_random_rotation](uv_random_rotation.png)

## @example uv_to_cloth.py
# Convert uv islands to the cloth pieces with extra borders to be sewed together
# ![uv_to_cloth.py](uv_to_cloth.png)

## @example uv_stats.py
# Calculate the square thash for the UV islands
# ![uv_stats.py](uv_stas.png)

## @example random_spheres.py
# create random spheres in retopo room, then remove one of groups, collapse edges randomly
# ![random_spheres.py](random_spheres.png)

## @example hairy_sphere.py
# This is example just to discover operations over meshes in the retop room. There we create random spheres in retopo rool, delete one of groups, select random faces, extrude them and move along normals.
# ![hairy_sphere.py](hairy_sphere.png)

## @example virus.py
# Low-poly virus modeling
# ![virus.py](virus.png)

## @example Autoexport.py
# The script used for the File->Export->Decimate > Auto UV-Map > Export
# ![Autoexport.py](auto_export.png)


## @example Break_mesh_by_cracks.py
# Break the current volume with realistic cracks
# ![Break_mesh_by_cracks.py](Break_mesh_by_cracks.png)

## @example render_with_shadow.py
# Render object from the random top view with random light position. The object rendered as if it drops the shadow on the invisible plane. The shadow represented as the alpha channel of the final image.
# ![render_with_shadow.py](render_with_shadow.png)