#pragma once

template<class TYPE>
class cMap2D{
	public:
		TYPE* _data = 0;
		int Width = 0;
		int Height = 0;
		bool Changed = false;
		inline cMap2D();
		inline cMap2D(const int aWidth, const int aHeight);
		inline ~cMap2D();
		inline void newSize(const int aWidth, const int aHeight);
		inline void fill(const TYPE aSample);
		inline int itemsCount();
		inline TYPE& Get(const int aIndex);
		inline TYPE& Get(const int aX, const int aY);
		inline void Change(const int aX, const int aY, const TYPE aValue);
		inline const TYPE & operator [] (const int aIndex) const;
		inline TYPE & operator [] (const int aIndex);
};


template<class TYPE>
inline const TYPE & cMap2D<TYPE>::operator [] (const int aIndex) const {
	cAssert(aIndex >= 0 && aIndex < itemsCount());
	return _data[aIndex];
}

template<class TYPE>
inline TYPE & cMap2D<TYPE>::operator [] (const int aIndex) {
	cAssert(aIndex >= 0 && aIndex < itemsCount());
	return _data[aIndex];
}


template <class TYPE>
inline cMap2D<TYPE>::cMap2D(int aWidth, int aHeight){
	newSize(aWidth, aHeight);
}

template <class TYPE>
inline cMap2D<TYPE>::cMap2D(){
	newSize(0, 0);
	byte* b = (byte*)&_data[0];
	for (int i = 0; i < itemsCount()*sizeof(TYPE); i++){
		b[i] = 0;
	}
}

template <class TYPE>
inline cMap2D<TYPE>::~cMap2D(){
	if (_data) delete[] _data;
}

template <class TYPE>
inline void cMap2D<TYPE>::newSize(int aWidth, int aHeight){
	if (Width == aWidth && Height == aHeight) return;

	TYPE* iNewPtr = new TYPE[aWidth*aHeight];

	int minCnt = aWidth*aHeight;
	if (_data){
		if (minCnt > Width*Height) minCnt = Width*Height;
		for (int i = 0; i < minCnt; i++) iNewPtr[i] = _data[i];
		delete[] _data;
	}
	Width = aWidth;
	Height = aHeight;
	_data = iNewPtr;
//	for (int i = minCnt; i < Width*Height; i++) _data[i] = 0;
	byte* b = (byte*)&_data[0];
	for (int i = minCnt*sizeof(TYPE); i < itemsCount()*sizeof(TYPE); i++){
		b[i] = 0;
	}

}

template <class TYPE>
inline void cMap2D<TYPE>::fill(const TYPE aSample){
	int cnt = Width*Height;
	for (int i = 0; i < cnt; i++){
		_data[i] = aSample;
	}
	Changed = false;
}

template <class TYPE>
inline int cMap2D<TYPE>::itemsCount(){
	return Width*Height;
}

template <class TYPE>
inline void cMap2D<TYPE>::Change(const int aX, const int aY, const TYPE aValue){
	int idx = aX + aY * Width;
	cAssert(aX >= 0 && aX < Width && aY >= 0 && aY < Height && idx < itemsCount());
	Changed = true;
	_data[aX + aY * Width] = aValue;
}

template <class TYPE>
inline TYPE& cMap2D<TYPE>::Get(int aIndex){
	cAssert(aIndex >= 0 && aIndex < itemsCount());
	return _data[aIndex];
}

template <class TYPE>
inline TYPE& cMap2D<TYPE>::Get(int aX, int aY){
	cAssert(aX >= 0 && aX < Width && aY >= 0 && aY < Height);
	return _data[aX + aY * Width];

}
