#pragma once

template<class KEYTYPE, class VALUETYPE>
class cDictionary{
	public:
		cList<KEYTYPE> _KeysList;
		cList<VALUETYPE> _ValueList;
		inline cDictionary();
		inline ~cDictionary();
		inline int Count();
		inline VALUETYPE& Get(const KEYTYPE aKey);
		inline int Add(const KEYTYPE aKey, const VALUETYPE aValue);
		inline void Clear();
		inline bool ConstainKey(const KEYTYPE aKey);
		inline int IndexOfKey(const KEYTYPE aKey);
		inline const VALUETYPE & operator [] (const KEYTYPE aKey) const;
		inline VALUETYPE & operator [] (const KEYTYPE aKey); 
};


template<class KEYTYPE, class VALUETYPE>
inline const VALUETYPE & cDictionary<KEYTYPE, VALUETYPE>::operator [] (const KEYTYPE aKey) const {
	for (int i = 0; i < Count(); i++){
		if (_KeysList[i] == aKey) return _ValueList[i];

	}
	return _ValueList[0];
}

template<class KEYTYPE, class VALUETYPE>
inline VALUETYPE & cDictionary<KEYTYPE, VALUETYPE>::operator [] (const KEYTYPE aKey) {
	for (int i = 0; i < Count(); i++){
		if (_KeysList[i] == aKey) return _ValueList[i];

	}
	return _ValueList[0];
}

template<class KEYTYPE, class VALUETYPE>
inline cDictionary<KEYTYPE, VALUETYPE>::cDictionary(){
	//
	_ValueList.Clear();
	_KeysList.Clear();
}

template<class KEYTYPE, class VALUETYPE>
inline cDictionary<KEYTYPE, VALUETYPE>::~cDictionary(){
	//
}

template<class KEYTYPE, class VALUETYPE>
inline int cDictionary<KEYTYPE, VALUETYPE>::Count(){
	return _KeysList.Count();
}

template<class KEYTYPE, class VALUETYPE>
inline VALUETYPE& cDictionary<KEYTYPE, VALUETYPE>::Get(const KEYTYPE aKey){
	for (int i = 0; i < Count(); i++){
		if (_KeysList[i] == aKey) return _ValueList[i];

	}
	return _ValueList[0];
}

template<class KEYTYPE, class VALUETYPE>
inline bool cDictionary<KEYTYPE, VALUETYPE>::ConstainKey(const KEYTYPE aKey){
	for (int i = 0; i < Count(); i++){
		if (_KeysList[i] == aKey) return true;

	}
	return false;
}

template<class KEYTYPE, class VALUETYPE>
inline int cDictionary<KEYTYPE, VALUETYPE>::IndexOfKey(const KEYTYPE aKey) {
	for (int i = 0; i < Count(); i++) {
		if (_KeysList[i] == aKey) return i;

	}
	return -1;


}


template<class KEYTYPE, class VALUETYPE>
inline void cDictionary<KEYTYPE, VALUETYPE>::Clear(){
	_KeysList.Clear();
	_ValueList.Clear();
}

template<class KEYTYPE, class VALUETYPE>
inline int cDictionary<KEYTYPE, VALUETYPE>::Add(const KEYTYPE aKey, const VALUETYPE aValue){
	for (int i = 0; i < Count(); i++){
		if (_KeysList[i] == aKey){
			_ValueList[i] = aValue;
			return i;
		}
	}
	_KeysList.Add(aKey);
	_ValueList.Add(aValue);
	return _KeysList.Count()-1;

}
