#pragma once

#include "ObjectsPlacers.h"
namespace SG {
	class SG_ObjUI;
	class SG_BasePrim;
}
class WidgetsScheme;

void SoftBooleansForPrimitives();
void SoftBooleansForVolumes();
class VolumeObject;
class APICALL BasePrim:public BaseClass{
public:
	BasePrim(){
		SkipMeshPreview=false;
		IsCustom=false;
		UseSector = false;
	}
	virtual WidgetsScheme* GetScheme(){return NULL;}
	virtual void Render(){}
	virtual void SetParams(){}
	virtual void ResetAxis(){}
	virtual void ResetPosition(){}
	virtual void ResetSize(){}
	virtual void CreateObject(VolumeObject* VO,int Subtract){}
	virtual void CreateRetopoObject();
	virtual void GetPosition(comms::cVec3& pos) {}
	virtual void GetName(cStr& s){s="prm_";s+=GetClassName();}
	virtual void GetName2(cStr& s){s="";}
	virtual int GetSubIndex(){return 0;}
	virtual void InitEnum(){};
	virtual void AfterLoad(){};
	virtual bool SupportsSurfaceMode(){return true;}
	virtual bool AllowRectSelection(){return true;}
	virtual void PostPlaceOnPen(){};
	virtual void SaveExtraData(BinStream& bs);
	virtual void LoadExtraData(BinStream& bs);
	virtual int GetPresenceMask(){ return 1; }//mask | 1 - present in Sculpt room, mask | 2 - present in Retopo room
	virtual void Transform(const Matrix4D& m) {}

	//core api code

	static cStr _vec3(const Vector3D& pos);
	static cStr position(const Vector3D& pos);
	static cStr number(float value);
	static cStr operation(int op);
	virtual bool GetCoreAPICommand(cStr* result) { return false; }

	int GeneralIndex;
	int BaseIndex;
	int SubIndex;
	int CurIndex;
	bool SkipMeshPreview;
	bool IsCustom;
	bool UseSector;
	static bool TempHidePreview;
	static HashSummator TempHidePreviewHash;
	static bool UseDiameter;

	void CopySGTo(BasePrim* P) {
		P->sgObj = sgObj;
	}
	SG::SG_BasePrim* GetSGPrim() const;
	
	void DropUndo();
	virtual bool SwapAxis(){return false;}
	
	static float DetailsLevel;
	cStr CustomName;	
	bool Eq(BasePrim* bp){
		cStr s1;
		cStr s2;
		GetName(s1);
		bp->GetName(s2);
		return cStr::Equals(s1,s2);
	}
	bool Eq2(BasePrim* bp){
		cStr s1;
		cStr s2;
		GetName(s1);
		bp->GetName(s2);
		if(cStr::Equals(s1,s2)){
			GetName2(s1);
			bp->GetName2(s2);
			return cStr::Equals(s1,s2);
		}
		return false;
	}
	virtual void CopyInfoTo(BasePrim* P){
		P->GeneralIndex=GeneralIndex;
		P->BaseIndex=BaseIndex;
		P->SubIndex=SubIndex;
		P->CurIndex=CurIndex;
	};
	virtual const char* GetCategory(){return "";}
	static void RenderPBRMesh(StaticMesh* sm, const Matrix4D& Transform, float OpMod = 1.0);
	void RenderMeshPreview(StaticMesh* sm,const Matrix4D& Transform,float OpMod=1.0);
	void RenderMeshPreviewSymm(StaticMesh* sm, const Matrix4D& Transform);
	static void RenderMeshWireframe(comms::cMeshContainer* mc, const Matrix4D& Transform);
	virtual void BeforeChangeMember(BaseClass* MembClass, void* MembPtr, void* MembExtra, const char* MembName);
	virtual bool OnScriptRecorder(BaseClass* MembClass, void* MembPtr, void* MembExtra, const char* MembName);
	
};
class VoxTreeBranch;
class APICALL BooleanSettings:public BaseClass{
public:
	BooleanSettings();
	bool display_surf;
	bool display_vox;
	bool display_shell;
	bool UseSoftBooleansForVoxels;
	bool TakeVoxelBooleansRadiusFromBrush;
	float VoxelsSoftBooleansRadius;
	bool UseSoftBooleans;
	float SoftBooleansRadius;
	int SoftEdgeShape;
	int EdgeDivisionsCount;
	int EdgeRelaxation;
	One2DCurve CustomSoftEdge;
	SERIALIZE_LATER();
	void Apply(VoxTreeBranch* cur);
	void Store();
	void RestoreDefaults();
	void Edit(const char* message);
};
extern BooleanSettings PrimitivesBoolSettings;
extern BooleanSettings VolumesBoolSettings;
extern BooleanSettings CutoffBoolSettings;
class APICALL ScopedBools{
	BooleanSettings prev;
	BooleanSettings* bs;
public:
	ScopedBools(BooleanSettings& b);
	~ScopedBools();
};
