#pragma once

/**
\brief Base class for all popup windows.
\details
Window can be placed in the control panel.
*/
class APICALL PopupWindow :public BaseClass{
public:
	PopupWindow();
	~PopupWindow();
    /**
    \brief Class to be edit in pop-up window.
    \details By default this class will be edit.
    */
	virtual BaseClass* GetClass(){return this;}
    /**
    \brief If returned class is NULL the next function will be called to create UI.
    */
	virtual void CreateUI(FrameWidget* root, const Rct& R){}
	/**
    \brief Is it present in Windows->Popups?
    \details
    Returns nonzero value - preferred position from the top in windows list,
    returns big value to place in the bottom.
    */
	virtual int PresentInWindowsList(){ return 1; }
	
	/**
	 * \brief The bigger value returned, the lower position in windows list the window will get.
	 * \return the value for windows sorting.
	 */
	virtual double GetWindowSortValue() { return 0; }
	/**
    \brief Get default hotkeys by default.
    */
	virtual const char* GetDefaultHotkey(){ return NULL; }
	/**
	 * \brief Resturn true and set special size when the window triggered by hokey.
	 */
	virtual bool GetSizeWhenTriggeredByHotkey(cVec2& size) { return false; }
    /**
	\brief Is it present in Top Navigation Bar?
    \details Returns non-zero position of icon from the left.
    */
	virtual int PresentInNaviBar(){ return 0; }
	/**
	\brief Is it present in Activity (top right list of active elements like current pen, material, stencil) panel?
	\details Returns priory of presence. Lower value means presence in the left side. 0 means that window is not present in activity bar.
	*/
	virtual float PresentInActivityBar() { return 0.0; }
	/**
	\brief returns the icon for the activity bar.
	\details Icon is not permanent, this function called each frame to get current state of the icon.
	*/
	virtual IconInfo GetIconInActivityBar() { return IconInfo(); }
	/**
    \brief Icon name to show in navi bar.
    */
	virtual IconInfo GetIcon(){ return IconInfo(); }
	/**
    \brief Window name to show in Windows->Popups and window header.
    */
	virtual const char* GetWindowID(){ return "Sample"; }
	/**
    \brief Returns nonzero value if you need fixed window width when called from Navi bar.
    */
	virtual int GetFixedWidth(){ return 0; }
	/**
    \brief Returns nonzero value if you need fixed window height when called from Navi bar.
    */
	virtual int GetFixedHeight(){ return 0; }
	virtual bool AllowWindowResize(){ return true; }
    /**
	\brief Get default placement and size.
	\details
    Returns `cVec2( x, y ), x = 0..1` in workspace range,
    `0 - left, 1 - right, y = 0..1, 0 - top, 1 - bottom`.
    */
    virtual cVec2 GetDefaultPlacement(){ return cVec2( 1, 0 ); }
	/**
    \brief Returns default window width.
    */
	virtual float GetDefaultWidth(){ return float(_ui_scale(240)); }
    /**
    \brief Returns default window width.
    */
    virtual float GetDefaultHeight(){ return float(_ui_scale(240)); }
	
	/**
	 * \brief Return true if you want to expand class parameters on the full height (whenever possible) when class hashsumm changes.
	 */
	virtual bool KeepExpanded() {
		return false;
	}

	//Events:

    /**
	\brief Called when Show or PopUp or Window->Popups->... called.
    */
	virtual void OnActivate(){}
    /**
	\brief Called when user closes the window or Close() called.
    */
	virtual void OnClose(){}
    /**
	\brief Called each frame.
    */
	virtual void Process(){}

	//Utilites:	
#ifndef PY_PARSER
	/// \brief Show the window if it is hidden.
	void Show();
	/// \brief Show the window if it is called from menu, pop-up window temporary if it is called by hotkey.
	void AutoShow();
#endif !PY_PARSER
	/// \brief Pop-up under cursor for temporary showing.
	void PopUp();
	/// \brief Close the window.
	void Close();
	/// \brief Pop-up near rectangle. X/Y alingn: 0:Left, 1:Center, 2:Right
	void PopUpNearRect(const Rct& R, int Xalign, int Yalign);
#ifndef PY_PARSER
	/// \brief Refresh.
	void RefreshUI();
#endif
	///check if window is in dock
	bool IsInDock();

	FrameWidget* CreateFixedPopUpFrame(Rct R);
	static void CloseFixedPopup(BaseWidget* p);

	/// serialize the window data to the 3B file<summary>
	virtual DWORD GetSaveMagic() { return 0; }
	virtual void LoadData(BinStream& BS) {}
	virtual void SaveData(BinStream& BS) {}
	/// <summary>
	/// called when New scene triggered
	/// </summary>
	virtual void OnNewScene(){}
	virtual void WhenLayoutRestored() {}
	virtual bool HandleCommand(const char* id) { return false; }
	virtual bool MayHandleCommand(const char* id) { return false; }

	/// \brief Registering window in system.
	static void Register(PopupWindow* win);

	//////////////////////////////////////////

	void InitWindow();
	FrameWidget* Frame;
	static ClassArray<PopupWindow> WindowList;
	static void AddToWindowsMenu(TextMenu* menu);
	static void TestPwMouseOv(cPtrDiff w);
	static void AddToNaviBar(BaseWidget* bar,int dy,int btsize);
	static bool Validate(PopupWindow* w);
	static PopupWindow* Find(const char* Name);
#ifndef PY_PARSER
	static bool Show(const char* Name);
	static bool AutoShow(const char* Name);
	static void RefreshUI(const char* Name);
#endif
	static void InitByName(const char* Name);
	static void OnActivateByName(const char* Name);
	static void OnCloseByName(const char* Name);
	static int GetNaviCount();
	static void ToggleNaviCom(cPtrDiff w);
	static void InitAllWindows();
	static void CloseAllWindows();
	DockableHeader* GetHeader();

	

	HashSummator ClassHash;
	HashSummator PrincipalClassHash;
};
class ItemsFolder;
int AddFilterLine(BaseWidget* parent, cStr* filter, int x0, int y0, std::function<void()> report = nullptr);
class APICALL ItemsFolderUI :public PopupWindow{
protected:
	HashSummator PrevHash;
	int IconsSize;
	void FoldersLines(BaseWidget* CMD);
public:
	cStr FilterString;
	virtual BaseClass* GetClass(){ return NULL; }
	ItemsFolderUI(){
		PrevHash.Clear();
		IconsSize = 0;
	}
	virtual double GetWindowSortValue() { return 7; }
	/// \brief Making window like pens, materials, objects etc.
	virtual ItemsFolder* GetItemsFolder(){ return NULL; }
	virtual void CreateUI(FrameWidget* root, const Rct& R);

	virtual int					GetItemsCount(){ return 0; }
	virtual int*				GetIconSizeVar(){
		return &IconsSize;
	}
	virtual int					GetCurrentItem(){ return 0; }
	virtual bool				MayAddExistingFolder(){ return false; }
	virtual void				AddExistingFolder(){}
	virtual const char*			AddExistingFolderTextID() { return "ADD_EXIST_FOLDER"; }
	virtual void				OnRenderElement(BaseWidget* w, int elIdx){}
	virtual void				OnSelect(int idx){}
	virtual void				CreateCustomHint(BaseWidget* w, int elIdx){}
	virtual void				DeleteElement(int idx){}
	virtual void				AddNewElement(){}
	virtual bool				OnDropExternalItem(){ return false; }
	virtual bool				OnDropWidget() { return false; }
	virtual int					GetMinIconSize() { return _ui_scale(8) + 8; }
	virtual void				Process();
	bool						UpdateHash();
	

	//syntax for extra rmb elements "[options0]Element0,[options1]Element1,..."
	//[options] syntax: [option1 option2 ...]
	//options list:
	//"default" - usee this element as default for rmb menu 
	//"bottom" - place at the bottom of the menu
	virtual const char*			GetExtraRmbElements(int el){ return nullptr; }
	virtual const char*			GetExtraDockProperyElements() { return nullptr; }
	virtual void				ExecutePropertyElement(const char* el,int idx){}
	virtual bool				HandleCommand(const char* id) override;
	virtual bool				MayHandleCommand(const char* id) override;


	void Invalidate();
};