#pragma once
//#include "octree/octree.h"

#include <future>
template<class param>
class tasks_queue {
	const int max_threads = 63;
	std::mutex m;
	BigDynArray<param> params;
	int taken;
	std::function<void(const param&)> caller;
	std::future<void>* threads;
	int n_actual;
	bool finished;
	void consume();

public:
	tasks_queue();
	~tasks_queue();
	void operator << (const std::function<void(const param&)>& fn);
	void operator << (const param& p);
	void finish();
};

template <class param>
void tasks_queue<param>::consume() {
	bool take = false;
	do {
		param pr;
		take = false;
		m.lock();
		if (taken < params.Count()) {
			pr = params[taken++];
			take = true;
		}
		m.unlock();
		if (take) {
			caller(pr);
		}
	} while (take || !finished);
}

template <class param>
tasks_queue<param>::tasks_queue() {
	taken = 0;
	n_actual = 0;
	finished = false;
	threads = nullptr;
}

template <class param>
tasks_queue<param>::~tasks_queue() {
	if (threads)delete[]threads;
}

template <class param>
void tasks_queue<param>::operator<<(const std::function<void(const param&)>& fn) {
	caller = fn;
}

template <class param>
void tasks_queue<param>::operator<<(const param& p) {
	m.lock();
	int np = params.Add(p);
	m.unlock();
	if (np == 1) {
		n_actual = std::thread::hardware_concurrency() - 1;
		if (n_actual > max_threads) {
			n_actual = max_threads;
		}
		if (n_actual < 3)n_actual = 3;
		threads = new std::future<void>[n_actual];
		for (int i = 0; i < n_actual; i++) {
			threads[i] = std::async(
				[this] {
					this->consume();
				});
		}
	}
}

template <class param>
void tasks_queue<param>::finish() {
	finished = true;
	consume();
	for (int i = 0; i < n_actual; i++) {
		threads[i].get();
	}
}

struct CellElmAB{
	CellElmAB(const AABoundBox& ab){
		c=ab.GetCenter();
		sz=ab.GetSize()/2.0;
	}
	CellElmAB(const AABoundBox& ab,float k){
		c=ab.GetCenter();
		sz=ab.GetSize()*k/2.0;
	}
	CellElmAB(){}
	Vector3D c;
	Vector3D sz;
	void* CellPtr;
	int idx;
};
class CellElmABNode;
class APICALL CellElmNodeAllocator{
	std_OnePoolType pool;
public:
	CellElmNodeAllocator();
	~CellElmNodeAllocator();
	void Clear();
	CellElmABNode* alloc();
	tasks_queue<std::tuple<CellElmABNode*, int, int, int>>* tasker;
};
struct IntersParam{
	Vector3D Orig;
	Vector3D Dir;
	float ScanDist;
	StackArray<CellElmABNode*,64> res;
};
class APICALL CellElmABNode {
public:
	AABoundBox AB; // node's bounding box, if negative - no children there, use cell data instead
	union{
		CellElmABNode* m_children[2]; // child nodes of this node	
		struct{
			void* CellPtr;
			int idx;
		};
	};
	void Init(cList<CellElmAB>& List,int Start,int Count,int depth,CellElmNodeAllocator& alloc);
	void Init(BigDynArray<CellElmAB>& List, int Start, int Count, int depth, CellElmNodeAllocator& alloc);
	void Init(cList<CellElmAB*>& List,int Start,int Count,int depth,CellElmNodeAllocator& alloc);
	void FindIntersections(IntersParam& intrs,int dbg=0);
	void FindIntersectionsBothSides(IntersParam& intrs, int dbg = 0);
	void FindAB(AABoundBox& ab, const std::function<void(void*, int idx)>& fn);
	void Clear(CellElmNodeAllocator* alloc=NULL);
};

template <class Elem>
class VolumeCells{
public:
	uni_hash<Elem,tri_DWORD,100000,10000> Cells;
	Elem at(int x,int y,int z){
		Elem* E=Cells.get(x,y,z);
		if(E)return *E;
		else return 0;
	}
	Elem& operator () (int x,int y,int z){		
		Elem* E=Cells.get(tri_DWORD(x,y,z));
		if(E)return *E;
		else{
			Elem E=0;
			return *Cells.add_quick(tri_DWORD(x,y,z),E);
		}
	}
	void add(int x,int y,int z,Elem V){
		Cells.add_quick(tri_DWORD(x,y,z),V);
	}
	void SetCashSize(int sz){
		Cells.set_table_size(sz);
	}
};
typedef VolumeCells<int> IntCells3D;
struct OctLink{
	int id;
	int next;
};
class APICALL OcScan {
public:
	OcScan();
	~OcScan();
	//Octree<int>*		FTree;
	IntCells3D* FTree;
	AABoundBox			AB;
	//cList<OctLink>	Link;
	float				SideSize;
	float				MicroSide;

	__forceinline int iclamp(int v) {
		if (v < 0)return 0;
		if (v >= int(SideSize))return int(SideSize) - 1;
		return v;
	}
	void Create(AABoundBox& AB, int Side);
	void Scan(Vector3D Pos, Vector3D Dir, float InDepth, float OutDepth, cList<int>& Res, int maxv = 1000000);
	void AddAABB(AABoundBox& AB, int id);
	void Clear();
	bool Valid();
};
class APICALL OcScan2{
public:
	OcScan2();
	~OcScan2(){
		Clear();
	};

	CellElmNodeAllocator alloc;
	CellElmABNode Root;
	cList<CellElmAB> Temp;


	void Create(AABoundBox& AB,int Side){}
	void Scan(Vector3D Pos,Vector3D Dir, float InDepth,float OutDepth,StackArray<int,64>& Res,int maxv=1000000);
	void AddAABB(AABoundBox& AB,int id);
	void Clear();
	bool Valid();
};
