#pragma once

/** \brief Draw antialiased line. The advance is that if parameters are uncanged it teakes the StaticMesh from the cache.
 * It uses HashSummator to determine if the lines scene is unchanged. It it is unchanged it will use the previous mesh and
 * works lighting fast because of such mechanism.
 * 
 * \param nPoints The amount of points in the scene
 * \param close The curve is closed, last and first points should get the same coordinate in this case
 * \param useZ In this case mesh will be drawn in 2 passes, the curve on the background will be less visible
 * \param pointGetter The callback (lambda usually) to get the points. The parameters of the \b pointGetter:\n
 * 
 * \param Vector3D& The space position of the point,
 * \param DWORD& The color of the point,
 * \param float& The thickness in 2D.
 * It should return true if line breaks at this point, then next point (if exists) starts the new line.\n
 * So, you may draw multiple lines at one draw primitive.\n
 * 
 */

APICALL void DrawAALine(int nPoints, bool closed, bool useZ, std::function<bool(int, Vector3D&, DWORD&, float&)> pointGetter, float bgOpacity = 0.35f);
APICALL void SetAABias(float b);

/// Older approach to draw line-by-line. It is much better to use functional approach.
APICALL void DrawAALine(const Vector3D& p1, const Vector3D& p2, DWORD C1, DWORD C2, float Thickness1, float Thickness2, bool Flush = true);
/// Call the DrawAALine one-by-one and then, at the end call FlushAALines. The lines will be actually drawn
APICALL void FlushAALines();

/// Draw 2D line
APICALL void DrawAALine(float x1, float y1, float x2, float y2, DWORD C1, DWORD C2, float Thickness1, float Thickness2, bool Flush = true);
/// Draw the circle in space, the tweaker may vary color and the point position
APICALL void DrawAACircle(const Vector3D& pc, const Vector3D& n, float R, DWORD C, float Thickness, int nseg, std::function<void(Vector3D&, DWORD&)> tweaker = nullptr);
