#pragma once
#include "stackarray.h"
struct __emptystruct {
	
};
//simplified and lightweight version of uni_hash
//very simple key->element correspondence to make fast correspondence tables
//supports multiple elements by key
template <class Key, int TableSize = 1024, int PoolSectionSize = 1024>
class void_hash {
	struct __temp {
		__temp() {
			
		}
		union {
			__emptystruct E;
			Key K;
		};
		int next;
	};
	StackArray<__temp, PoolSectionSize> Pool;
	StackArray<int, PoolSectionSize> Deleted;
	int* Table;
	int DynSize;
	int counter;
	void _testsize();
public:
	void_hash() {
		DynSize = 0;
		Table = nullptr;
		counter = 0;
	}
	~void_hash() {
		clear();
	}
	//setting table size allowed only when hash is still empty
	void set_table_size(int sz);
	//get element by key
	inline bool get(const Key& v, int SubIndex = 0);
	//add element e by key k and get pointet to element in hash
	inline void add(const Key& k);
	inline void add_once(const Key& k);	
	inline void del(const Key& k);
	inline void add_quick(const Key& k);
	inline int size();
	inline int size(const Key& k);
	inline void start_scan(Key K, hash_context& ct);
	inline void start_scan(hash_context& ct);
	inline void* next(hash_context& ct);
	inline void clear();
	inline Key* _key(hash_context* co) const;
	inline bool test_integrity();
	inline void refine_table();
};

template<class Key, int TableSize, int PoolSectionSize>
inline void void_hash<Key, TableSize, PoolSectionSize>::set_table_size(int sz) {
	if (DynSize == 0)DynSize = -sz;
}

template<class Key, int TableSize, int PoolSectionSize>
inline void void_hash<Key, TableSize, PoolSectionSize>::_testsize() {
	if (DynSize <= 0) {
		if (DynSize == 0)DynSize = TableSize;
		else DynSize = -DynSize;
		if (Table)delete[]Table;
		Table = new int[DynSize];
		memset(Table, 0, DynSize * 4);
	}
	if(counter++>512) {
		counter = 0;
		refine_table();
	}
}
template<class Key, int TableSize, int PoolSectionSize>
inline bool void_hash<Key, TableSize, PoolSectionSize>::get(const Key& v, int SubIndex) {
	_testsize();
	if (DynSize == 0)return NULL;
	int h = DWORD(v) % DynSize;
	int ptr = Table[h];
	while (ptr > 0) {
		__temp& vv = Pool[ptr - 1];
		if (vv.K == v) {
			if (SubIndex == 0)return true;
			SubIndex--;
		}
		ptr = vv.next;
	}
	return false;
}

template<class Key, int TableSize, int PoolSectionSize>
inline void void_hash<Key, TableSize, PoolSectionSize>::clear() {
	DynSize = 0;
	Pool.Clear();
	if (Table)delete(Table);
	Table = nullptr;
}

template<class Key, int TableSize, int PoolSectionSize>
inline void void_hash<Key, TableSize, PoolSectionSize>::add(const Key& k) {
	_testsize();
	DWORD D = DWORD(k);
	DWORD h = D % DynSize;
	int ptr = Table[h];
	if (Deleted.Count()) {
		int ptrd = Deleted.pop_back();
		__temp& vv = Pool[ptrd];
        vv.E = {};
		vv.K = k;
		vv.next = ptr;
		ptr = ptrd;
	}
	else {
		__temp vv;
        vv.E = {};
		vv.K = k;
		vv.next = ptr;
		ptr = Pool.Add(vv);
	}
	Table[h] = ptr + 1;
}

template<class Key, int TableSize, int PoolSectionSize>
inline void void_hash<Key, TableSize, PoolSectionSize>::add_once(const Key& k) {
	if (get(k))return;
	add_quick(k);
}

template<class Key, int TableSize, int PoolSectionSize>
inline void void_hash<Key, TableSize, PoolSectionSize>::del(const Key& k) {
	_testsize();
	if (DynSize == 0)return;
	DWORD D = DWORD(k);
	DWORD h = D % DynSize;
	int ptr = Table[h] - 1;
	int pptr = -1;
	while (ptr >= 0) {
		__temp* t = &Pool[ptr];
		int next = t->next;
		if (t->K == k) {
			if (pptr == -1)Table[h] = next;
			else Pool[pptr].next = next;
			t->next = -1;
			Deleted.Add(ptr);
		}
		else {
			pptr = ptr;
		}
		ptr = next - 1;
	}
}

template<class Key, int TableSize, int PoolSectionSize>
inline void void_hash<Key, TableSize, PoolSectionSize>::add_quick(const Key& k) {
	_testsize();
	DWORD D = DWORD(k);
	DWORD h = D % DynSize;
	int ptr = Table[h];
	if (Deleted.Count()) {
		int ptrd = Deleted.pop_back();
		__temp& vv = Pool[ptrd];
		vv.K = k;
		vv.next = ptr;
		ptr = ptrd;
	}
	else {
		__temp vv;
		vv.K = k;
		vv.next = ptr;
		ptr = Pool.Add(vv);
	}
	Table[h] = ptr + 1;
}

template<class Key, int TableSize, int PoolSectionSize>
inline int void_hash<Key, TableSize, PoolSectionSize>::size() {
	return Pool.Count() - Deleted.Count();
}

template<class Key, int TableSize, int PoolSectionSize>
inline int void_hash<Key, TableSize, PoolSectionSize>::size(const Key& k) {
	_testsize();
	if (DynSize == 0)return 0;
	int h = DWORD(k) % DynSize;
	int ptr = Table[h];
	int n = 0;
	while (ptr > 0) {
		__temp& vv = Pool[ptr - 1];
		if (vv.K == k)n++;
		ptr = vv.next;
	}
	return n;
}

template<class Key, int TableSize, int PoolSectionSize>
inline void void_hash<Key, TableSize, PoolSectionSize>::start_scan(Key K, hash_context& ct) {
	_testsize();
	ct.ScanAll = false;
	DWORD D = (DWORD)K;
	D %= DynSize;
	ct.ptr = NULL;
	int ptr = Table[D];
	if (ptr > 0) {
		__temp* t = &Pool[ptr - 1];
		while (t) {
			if (t->K == K) {
				ct.ptr = t;
				return;
			}
			int nn = t->next;
			if (nn > 0) {
				t = &Pool[nn - 1];
			}
			else t = NULL;
		}
	}
}
template<class Key, int TableSize, int PoolSectionSize>
inline void void_hash<Key, TableSize, PoolSectionSize>::start_scan(hash_context& ct) {
	_testsize();
	ct.ScanAll = true;
	ct.TblPos = 0;
	while (ct.TblPos < Pool.Count() && Pool[ct.TblPos].next == -1)ct.TblPos++;
	ct.TblPos;
}
template<class Key, int TableSize, int PoolSectionSize>
inline void* void_hash<Key, TableSize, PoolSectionSize>::next(hash_context& ct) {
	_testsize();
	if (ct.ScanAll) {
		while (ct.TblPos < Pool.Count() && Pool[ct.TblPos].next == -1)ct.TblPos++;
		if (ct.TblPos < Pool.Count()) {
			__temp& pp = Pool[ct.TblPos];
			ct.pptr = &pp;
			ct.TblPos++;
			return &pp.E;
		}
	}
	else {

		__temp* t = (__temp*)ct.ptr;
		__temp* t0 = t;
		if (t0) {
			while (t) {
				__temp* pt = t;
				int nn = t->next;
				if (nn > 0) {
					t = &Pool[nn - 1];
				}
				else {
					t = NULL;
					ct.ptr = NULL;
				}
				if (t && t->K == t0->K) {
					ct.ptr = t;
					break;
				}
			}
			ct.pptr = &t0;
			return &t0->E;
		}
	}
	return NULL;
}
template<class Key, int TableSize, int PoolSectionSize>
inline Key* void_hash<Key, TableSize, PoolSectionSize>::_key(hash_context* co) const {
	return &((__temp*)(co->pptr))->K;
}

template<class Key, int TableSize, int PoolSectionSize>
inline bool void_hash<Key, TableSize, PoolSectionSize>::test_integrity() {
	int sz = size();
	int szz = 0;
	for (int i = 0; i < Pool.Count(); i++) {
		if (Pool[i].next != -1)szz++;
	}
	assert(szz == sz);
	if (szz != sz) {
		return false;
	}
	for (int i = 0; i < Pool.Count(); i++) {
		if (Pool[i].next == i + 1) {
			assert(0);
			return false;
		}
	}
	for (int i = 0; i < DynSize; i++) {
		if (Table[i]) {
			__temp* t = &Pool[Table[i] - 1];
			while (t->next) {
				if (t->next < 0) {
					assert(0);
					return false;
				}
				t = &Pool[t->next - 1];
			}
		}
	}
	return true;
}

template <class Key, int TableSize, int PoolSectionSize>
void void_hash<Key, TableSize, PoolSectionSize>::refine_table() {
	if(DynSize > 0 && size() > DynSize + DynSize / 2) {
		BigDynArray<int, 4096> temp;
		int ds = DynSize;
		for (int i = 0; i < DynSize; i++) {
			int t = Table[i] - 1;
			if(t >=  0) {
				auto* a = &Pool[t];
				temp.Add(t);
				while(a) {
					if (a->next > 0) {
						t = a->next - 1;
						temp.Add(t);
						a = &Pool[t];
					}
					else break;
				}
			}
		}
		delete[]Table;
		DynSize *= 2;
		Table = new int[DynSize];
		memset(Table, 0, DynSize * 4);
		for (auto& a : temp) {
			auto& p = Pool[a];
			DWORD h = DWORD(p.K) % DynSize;
			int& t = Table[h];
			if (t) p.next = t;
			else p.next = 0;
			t = a + 1;
		}
	}
}
