// This example demonstrates the power of the dialogs and UI. It describes how to register the elements into the UI.
#include <CoreAPI.h>
//If you need the release build at full speed please change the Debug below to Release
//@config: Debug

// This example demonstrates the dialogs power. What we do?
// Try to load previously stored settings, show dialog, save settings if user pressed Ok

// let's define the class. 3DCoat uses class registration system (ClassEngine) to edit and serialize
// the class members. This is the easy demonstration of class registration. Look more at
// UserPrefs/CoreAPI/include/ClassEngine/class_reg.h

class MyClass:public BaseClass {
public:
	MyClass() {
		Integer = 0;
		IntSlider = 0;
		Float = 0;
		FloatSlider = 0.5;
		Checkbox = false;
		Radio1 = true;
		Radio2 = false;
		Droplist = 0;;
		String = "text";
		Coordinate = coat::vec3(1, 2, 3);
		color = 0xFFFF0000;//red
		texture = -1;
	}
	int Integer;
	int IntSlider;
	float Float;
	float FloatSlider;
	bool Checkbox;
	bool Radio1;
	bool Radio2;
	int Droplist;
	int texture;
	DWORD color;
	coat::str String;
	coat::str OpenFilepath;
	coat::str SaveFilepath;
	coat::vec3 Coordinate;

	void Button1() {
		Coordinate = coat::vec3(0);
	}

	void Button2(float parameter) {
		Coordinate = coat::vec3(parameter);
	}

	void ZeroCoordinate() {
		Coordinate = coat::vec3(0);
	}

	// this section used for the class serialization and visual presentation in the UI
	// pay attention that visualization and serialization may be separated if need.	
	SERIALIZE() {
		// NOHASH means that if you change values it does not influence the UI structure in dialug, so it will not be re-made if you change values
		// If you don't understand, just skip this notice, it is not so important)
		// But if you remove NOHASH dialog may flicker a bit when you change values.
		NOHASH{
			// REG_AUTO used to register the variable automatically to appear in UI
			REG_AUTO(Integer);

			// The slider 0..100 for integer values
			SLIDER(IntSlider, "IntSlider", 0, 100);

			// registering float number
			REG_AUTO(Float, "FloatWithChangedNameInUI");

			// registering float slider
			FSLIDER(FloatSlider, "FloatSlider", -1, 1, 100, false);

			// registering the checkbox
			REG_AUTO(Checkbox);

			// registering the radio buttons CHK_GROUP(1) identifies that they use group 1
			CHK_GROUP(1) REG_AUTO(Radio1);
			CHK_GROUP(1) REG_AUTO(Radio2);

			// the droplist, generally second parametr may be dynamic
			REG_DROPLIST(Droplist, "Droplist", "Case1|Case2|Case3");

			// the text string
			REG_AUTO(String);

			// register the texture ID
			REG_TEXTURE(texture);

			// color idntified by it's type - DWORD
			REG_AUTO(color);

			// open file dialog
			FILEPATH(OpenFilepath, "OpenFilepath", "load:*.tif;*.tiff;*.exr;*.tga;*.bmp;*.png");

			// save file dialog
			FILEPATH(SaveFilepath, "SaveFilepath", "save:*.tif;*.tiff;*.exr;*.tga;*.bmp;*.png");

			// 4 proportional columns and one fixed, the numbers used as width proportion for the columns, 5 next items taken into 5 columns
			UI_LAYOUT("1 1 1 1 []");
			// just some text the * means it is left-aligned
			TEXTMSG2("*Pos");

			// the coordinates, $ used to hide the name of variable and display only value. But if you serialize the class, $cx will be used as the tag name for this variable
			REG_AUTO(Coordinate.x, "$cx");
			REG_AUTO(Coordinate.y, "$cy");
			REG_AUTO(Coordinate.z, "$cz");

			// reguster function as the single icon, icons are referred from the data/material.io/black/
			ICON_BUTTON("clear", ZeroCoordinate, "DEL_SOMETHING_HINT");
			// end of columns

			//2 columns
			UI_LAYOUT("2");
			// call the function when used pressed button
			FUNCTION_CALL(Button1);

			// call function and pass parameters there, the Button2(4.0f) will be called in this case
			FUNCTION_CALL(Button2,"Button2",4.0f);
		}
	}
};

EXPORT
int main(){
	{
		MyClass p;
		// try to read the settings from the Documents\3DCoat\data\Temp\MyClass.json
		p.ReadFromFile("data/Temp/MyClass.json");
		coat::dialog().ok().cancel().params(&p).text("That are the parameters from the class").caption("caption")
			.onPress( // there we set the lambda that will be called when user will press Ok button
				[&](int button) {
					if(button == 1) {//Ok pressed
						// save settings to the the Documents\3DCoat\data\Temp\MyClass.json 
						p.WriteToFile("data/Temp/MyClass.json");
					}
				}).show();		
	}
	return 0;
}