﻿// Simple strings manipulations
#include <CoreAPI.h>
//If you need the release build at full speed please change the Debug below to Release
//@config: Debug

//this function just displays the string
void show(const char* string) {
	coat::dialog().text(string).ok().show();
}
// The main() will be called as soon as user will run the script
EXPORT
int main(){
	// There is multiple types of strings in c++, just the sort of zoo
	// This is c-style sctring
	const char* cs = "c-string";
	// this is c++ type string
	std::string cpps = "cpp-string";
	// this is c++ Unicode string
	std::wstring cppw = L"Unicode string☺";
	// if you use special characters, save the file with the UTF-8 encoding 
	// This is the native 3DCoat string:
	coat::str coatstr = "3DCoat supports all types of strigs: ";
	// You may use all strings types, but it is better to use 3DCoat native string
	// because it is very functionally rich and compatible with other strings types.
	// There we concatenate all that strings
	coatstr << cs << ", " << cpps.c_str() << ", " << cppw.c_str();
	// show what we got
	show(coatstr);
	// We recommend using the c string (const char*) and native 3DCoat strings coat::str whenever possible
	// They both are well compatible between each other.
	float fv = 1.252345f;
	int iv = 1234;
	// clear the string
	coatstr.Clear();
	coatstr << "Format values using the << operator: float: " << fv << ", int: " << iv;
	show(coatstr);

	coatstr.Clear();
	coatstr << coat::str::Format("Format values using the Format function: float: %.04f, int: %d", fv, iv);
	show(coatstr);

	coatstr.Clear();
	coatstr << "Different float precission: " << coat::str::ToString(fv,1) << " " << coat::str::ToString(fv, 2) << " " << coat::str::ToString(fv, 3);
	show(coatstr);

	// let we got some path
	coat::str path = coat::io::dataPath();
	path << "Log.txt";
	show("Let we got some path: " + path);
	show("Filepath: " + path.GetFilePath());
	show("Filepath: " + path.GetFileName());



	return 0;
}